/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relaxng;

import java.util.*;
import java.io.IOException;
import java.io.File;
import java.net.URL;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;
import jp.gr.java_conf.jaba2.xml.relax.expanded.*;

/**
 * URelaxNg
 *
 * @since   Jun. 13, 2001
 * @version Dec. 17, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public final class URelaxNg {
/*
    public static RNGGrammar buildGrammar(URL url) throws IOException {
	IProcessor processor = ProcessorFactory.getProcessor();
	return (buildGrammar(url, processor));
    }

    public static RNGGrammar buildGrammar(URL url, IProcessor processor)
	throws IOException {

	Document doc = processor.parseValidDocument(url);
	RNGrammar grammar = new RNGrammar(doc);
	return (new RNGGrammar(grammar));
    }
*/

    public static RNGGrammar buildGrammar(Element element, String baseURI) {
	element = distillGrammar(element); // XXX
	String localName = element.getLocalName();
	if (localName.equals("grammar")) {
	    RNGrammar grammar = new RNGrammar(element);
	    return (new RNGGrammar(grammar, baseURI));
	} else if (localName.equals("element")) {
	    RNElement rElement = new RNElement(element);
	    return (new RNGGrammar(rElement, baseURI));
	} else {
	    throw (new InternalError());
	}
    }

/*
    public static ERelax buildEModel(URL url) throws IOException {
	IProcessor processor = ProcessorFactory.getProcessor();
	return (buildEModel(url, processor));
    }

    public static ERelax buildEModel(URL url, IProcessor processor)
	throws IOException {

	Document doc = processor.parseValidDocument(url);
	RNGrammar grammar = new RNGrammar(doc);
	CRelax crelax = UCRelax.buildModel(grammar);
	ERelax erelax = UERule.buildModel(crelax);
	return (erelax);
    }
*/
    public static Element distillGrammar(Element source) {
	Document doc = source.getOwnerDocument();
	Element target = (Element)doc.importNode(source, false);
	NodeList children = source.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = children.item(i);
	    if (child instanceof Element) {
		String childNs = child.getNamespaceURI();
		if (childNs == null) {
		    childNs = "";
		}
		if (childNs.startsWith("http://relaxng.org")) {
		    target.appendChild(distillGrammar((Element)child));
		}
	    } else if (child instanceof Text) {
		target.appendChild(doc.importNode(child, false));
	    }
	}
	NamedNodeMap attrs = source.getAttributes();
	int nAttrs = attrs.getLength();
	for (int i = 0;i < nAttrs;i++) {
	    Attr attr = (Attr)attrs.item(i);
	    String uri = attr.getNamespaceURI();
	    if (uri == null || uri.startsWith("http://relaxer.org")) {
		target.setAttributeNode((Attr)doc.importNode(attr, false));
	    }
	}
	return (target);
    }

    public static String makeUri(String uri, String baseUri) {
	if (UURL.isURL(uri)) {
	    return (uri);
	} else if (new File(uri).isAbsolute()) {
	    return (uri);
	} else {
	    if (baseUri.endsWith("/")) {
		return (baseUri + uri);
	    } else {
		return (baseUri + "/" + uri);
	    }
	}
    }

    public static RNGSyntaxErrorException makeSyntaxErrorExceptionUnavailableUri(
	String uri,
	Exception e
    ) {
	return (
	    new RNGSyntaxErrorException(
		"Unavailable uri = " + uri + " (" + e.getMessage() + ")"
	    )
	);
    }
}
