package jp.gr.java_conf.jaba2.xml.relax.expanded.rText;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PList</b> is generated from pattern.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="list">
 *   <ref name="textPatterns"/>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="list"&gt;
 *   &lt;ref name="textPatterns"/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pattern.rng (Wed Nov 13 09:56:02 GMT+09:00 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class PList implements java.io.Serializable, IRNode, IPTextPatternChoice {
    // List<IPTextPatternChoice>
    private java.util.List textPattern_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>PList</code>.
     *
     */
    public PList() {
    }

    /**
     * Creates a <code>PList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PList(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PList(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PList(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PList(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PList(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PList(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        textPattern_.clear();
        while (true) {
            if (PData.isMatch(stack)) {
                addTextPattern(new PData(stack));
            } else if (PValue.isMatch(stack)) {
                addTextPattern(new PValue(stack));
            } else if (PRef.isMatch(stack)) {
                addTextPattern(new PRef(stack));
            } else if (PText.isMatch(stack)) {
                addTextPattern(new PText(stack));
            } else if (PGroup.isMatch(stack)) {
                addTextPattern(new PGroup(stack));
            } else if (PList.isMatch(stack)) {
                addTextPattern(new PList(stack));
            } else if (PChoice.isMatch(stack)) {
                addTextPattern(new PChoice(stack));
            } else if (POptional.isMatch(stack)) {
                addTextPattern(new POptional(stack));
            } else if (POneOrMore.isMatch(stack)) {
                addTextPattern(new POneOrMore(stack));
            } else if (PZeroOrMore.isMatch(stack)) {
                addTextPattern(new PZeroOrMore(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("list");
        int size;
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @return IPTextPatternChoice[]
     */
    public final IPTextPatternChoice[] getTextPattern() {
        IPTextPatternChoice[] array = new IPTextPatternChoice[textPattern_.size()];
        return ((IPTextPatternChoice[])textPattern_.toArray(array));
    }

    /**
     * Sets the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @param textPattern
     */
    public final void setTextPattern(IPTextPatternChoice[] textPattern) {
        this.textPattern_.clear();
        for (int i = 0;i < textPattern.length;i++) {
            addTextPattern(textPattern[i]);
        }
        for (int i = 0;i < textPattern.length;i++) {
            textPattern[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @param textPattern
     */
    public final void setTextPattern(IPTextPatternChoice textPattern) {
        this.textPattern_.clear();
        addTextPattern(textPattern);
        if (textPattern != null) {
            textPattern.setParentRNode(this);
        }
    }

    /**
     * Adds the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @param textPattern
     */
    public final void addTextPattern(IPTextPatternChoice textPattern) {
        this.textPattern_.add(textPattern);
        if (textPattern != null) {
            textPattern.setParentRNode(this);
        }
    }

    /**
     * Adds the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @param textPattern
     */
    public final void addTextPattern(IPTextPatternChoice[] textPattern) {
        for (int i = 0;i < textPattern.length;i++) {
            addTextPattern(textPattern[i]);
        }
        for (int i = 0;i < textPattern.length;i++) {
            textPattern[i].setParentRNode(this);
        }
    }

    /**
     * Gets number of the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @return int
     */
    public final int getTextPatternCount() {
        return (textPattern_.size());
    }

    /**
     * Gets the IPTextPatternChoice property <b>textPattern</b> by index.
     *
     * @param index
     * @return IPTextPatternChoice
     */
    public final IPTextPatternChoice getTextPattern(int index) {
        return ((IPTextPatternChoice)textPattern_.get(index));
    }

    /**
     * Sets the IPTextPatternChoice property <b>textPattern</b> by index.
     *
     * @param index
     * @param textPattern
     */
    public final void setTextPattern(int index, IPTextPatternChoice textPattern) {
        this.textPattern_.set(index, textPattern);
    }

    /**
     * Adds the IPTextPatternChoice property <b>textPattern</b> by index.
     *
     * @param index
     * @param textPattern
     */
    public final void addTextPattern(int index, IPTextPatternChoice textPattern) {
        this.textPattern_.add(index, textPattern);
    }

    /**
     * Remove the IPTextPatternChoice property <b>textPattern</b> by index.
     *
     * @param index
     */
    public final void removeTextPattern(int index) {
        this.textPattern_.remove(index);
    }

    /**
     * Remove the IPTextPatternChoice property <b>textPattern</b> by object.
     *
     * @param textPattern
     */
    public final void removeTextPattern(IPTextPatternChoice textPattern) {
        this.textPattern_.remove(textPattern);
    }

    /**
     * Clear the IPTextPatternChoice property <b>textPattern</b>.
     *
     */
    public final void clearTextPattern() {
        this.textPattern_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<list");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</list>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<list");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</list>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(textPattern_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PList</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "list")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (!target.isEmptyElement()) {
            if (PData.isMatchHungry(target)) {
                $match$ = true;
            } else if (PValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (PRef.isMatchHungry(target)) {
                $match$ = true;
            } else if (PText.isMatchHungry(target)) {
                $match$ = true;
            } else if (PGroup.isMatchHungry(target)) {
                $match$ = true;
            } else if (PList.isMatchHungry(target)) {
                $match$ = true;
            } else if (PChoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (POptional.isMatchHungry(target)) {
                $match$ = true;
            } else if (POneOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else if (PZeroOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PList</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PList</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
