package jp.gr.java_conf.jaba2.xml.relax.expanded.rText;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PData</b> is generated from pattern.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="data">
 *   <attribute name="type">
 *     <data type="token"/>
 *   </attribute>
 *   <zeroOrMore>
 *     <element name="param">
 *       <attribute name="name">
 *         <data type="token"/>
 *       </attribute>
 *       <optional>
 *         <attribute name="datatypeLibrary">
 *           <data type="token"/>
 *         </attribute>
 *       </optional>
 *       <text/>
 *     </element>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="data"&gt;
 *   &lt;attribute name="type"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;element name="param"&gt;
 *       &lt;attribute name="name"&gt;
 *         &lt;data type="token"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="datatypeLibrary"&gt;
 *           &lt;data type="token"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;text/&gt;
 *     &lt;/element&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pattern.rng (Wed Nov 13 09:56:02 GMT+09:00 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class PData implements java.io.Serializable, IRNode, IPTextPatternChoice {
    private String type_;
    // List<PDataParam>
    private java.util.List dataParam_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>PData</code>.
     *
     */
    public PData() {
        type_ = "";
    }

    /**
     * Creates a <code>PData</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PData(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PData</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PData(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PData</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PData(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PData</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PData(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PData</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PData(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PData</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PData(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PData</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PData(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PData</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PData(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PData</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PData(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PData</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PData</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PData</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        dataParam_.clear();
        while (true) {
            if (PDataParam.isMatch(stack)) {
                addDataParam(new PDataParam(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("data");
        int size;
        URelaxer.setAttributePropertyByString(element, "type", this.type_);
        size = this.dataParam_.size();
        for (int i = 0;i < size;i++) {
            PDataParam value = (PDataParam)this.dataParam_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PData</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PData</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PData</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PData</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PData</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PData</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the PDataParam property <b>dataParam</b>.
     *
     * @return PDataParam[]
     */
    public final PDataParam[] getDataParam() {
        PDataParam[] array = new PDataParam[dataParam_.size()];
        return ((PDataParam[])dataParam_.toArray(array));
    }

    /**
     * Sets the PDataParam property <b>dataParam</b>.
     *
     * @param dataParam
     */
    public final void setDataParam(PDataParam[] dataParam) {
        this.dataParam_.clear();
        for (int i = 0;i < dataParam.length;i++) {
            addDataParam(dataParam[i]);
        }
        for (int i = 0;i < dataParam.length;i++) {
            dataParam[i].setParentRNode(this);
        }
    }

    /**
     * Sets the PDataParam property <b>dataParam</b>.
     *
     * @param dataParam
     */
    public final void setDataParam(PDataParam dataParam) {
        this.dataParam_.clear();
        addDataParam(dataParam);
        if (dataParam != null) {
            dataParam.setParentRNode(this);
        }
    }

    /**
     * Adds the PDataParam property <b>dataParam</b>.
     *
     * @param dataParam
     */
    public final void addDataParam(PDataParam dataParam) {
        this.dataParam_.add(dataParam);
        if (dataParam != null) {
            dataParam.setParentRNode(this);
        }
    }

    /**
     * Adds the PDataParam property <b>dataParam</b>.
     *
     * @param dataParam
     */
    public final void addDataParam(PDataParam[] dataParam) {
        for (int i = 0;i < dataParam.length;i++) {
            addDataParam(dataParam[i]);
        }
        for (int i = 0;i < dataParam.length;i++) {
            dataParam[i].setParentRNode(this);
        }
    }

    /**
     * Gets number of the PDataParam property <b>dataParam</b>.
     *
     * @return int
     */
    public final int getDataParamCount() {
        return (dataParam_.size());
    }

    /**
     * Gets the PDataParam property <b>dataParam</b> by index.
     *
     * @param index
     * @return PDataParam
     */
    public final PDataParam getDataParam(int index) {
        return ((PDataParam)dataParam_.get(index));
    }

    /**
     * Sets the PDataParam property <b>dataParam</b> by index.
     *
     * @param index
     * @param dataParam
     */
    public final void setDataParam(int index, PDataParam dataParam) {
        this.dataParam_.set(index, dataParam);
    }

    /**
     * Adds the PDataParam property <b>dataParam</b> by index.
     *
     * @param index
     * @param dataParam
     */
    public final void addDataParam(int index, PDataParam dataParam) {
        this.dataParam_.add(index, dataParam);
    }

    /**
     * Remove the PDataParam property <b>dataParam</b> by index.
     *
     * @param index
     */
    public final void removeDataParam(int index) {
        this.dataParam_.remove(index);
    }

    /**
     * Remove the PDataParam property <b>dataParam</b> by object.
     *
     * @param dataParam
     */
    public final void removeDataParam(PDataParam dataParam) {
        this.dataParam_.remove(dataParam);
    }

    /**
     * Clear the PDataParam property <b>dataParam</b>.
     *
     */
    public final void clearDataParam() {
        this.dataParam_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<data");
        buffer.append(" type=\"");
        buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
        buffer.append("\"");
        buffer.append(">");
        size = this.dataParam_.size();
        for (int i = 0;i < size;i++) {
            PDataParam value = (PDataParam)this.dataParam_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</data>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<data");
        buffer.print(" type=\"");
        buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
        buffer.print("\"");
        buffer.print(">");
        size = this.dataParam_.size();
        for (int i = 0;i < size;i++) {
            PDataParam value = (PDataParam)this.dataParam_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</data>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setDataParamByString(String string) throws IOException, SAXException, ParserConfigurationException {
        setDataParam(new PDataParam(string));
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void addDataParamByString(String string) throws IOException, SAXException, ParserConfigurationException {
        addDataParam(new PDataParam(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(dataParam_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PData</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "data")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }
        $match$ = true;
        while (!target.isEmptyElement()) {
            if (!PDataParam.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PData</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PData</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
