/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EAttributeRefNode
 *
 * @since   Oct. 28, 2002
 * @version Oct. 28, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class EAttributeRefNode extends ENode implements IEOccurs {
    private EAttributeNode attributeNode_;
    private int occurs_;

    public EAttributeRefNode(EAttributeNode ref) {
	this(ref, OCCURS_ONE);
    }

    public EAttributeRefNode(EAttributeNode ref, int occurs) {
	super("attributeRef");
	attributeNode_ = ref;
	occurs_ = occurs;
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public EAttributeRefNode(EAttributeRefNode erNode) {
	super(erNode);
	attributeNode_ = erNode.attributeNode_;
	occurs_ = erNode.occurs_;
	setAttribute("occurs", UERule.getOccursSymbol(occurs_));
    }

    public final EAttributeNode getAttributeNode() {
	return (attributeNode_);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }

    public synchronized void lockWrite() throws InterruptedException {
	super.lockWrite();
	attributeNode_.lockWrite();
    }

    public synchronized void unlockWrite() throws InterruptedException {
	attributeNode_.unlockWrite();
	super.unlockWrite();
    }

    public synchronized boolean isLockWrite() {
	return (attributeNode_.isLockWrite());
    }

    public synchronized void lockRead() throws InterruptedException {
	super.lockRead();
	attributeNode_.lockRead();
    }

    public synchronized void unlockRead() throws InterruptedException {
	attributeNode_.unlockRead();
	super.unlockRead();
    }

    public synchronized boolean isLockRead() {
	return (attributeNode_.isLockRead());
    }
}
