/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;

/**
 * CMixed
 *
 * @since   Dec. 22, 1999
 * @version Nov.  8, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class CMixed extends CNode implements ICParticle, ICContentModel {
    private List particles_ = new ArrayList(); // List<ICParticle>

    public CMixed() {
    }

    public CMixed(RMixed rmixed, CModule module) {
	super(rmixed);
	RNode[] contents = rmixed.getContents();
	for (int i = 0;i < contents.length;i++) {
	    RNode content = contents[i];
	    if (content instanceof RRef) {
		particles_.add(new CRefWithLabel((RRef)content, module));
	    } else if (content instanceof RImportedLabelRef) {
		particles_.add(
		    new CRefImportedLabel((RImportedLabelRef)content, module)
		);
	    } else if (content instanceof RElement) {
		particles_.add(new CElement((RElement)content, module));
	    } else if (content instanceof RSequence) {
		particles_.add(new CSequence((RSequence)content, module));
	    } else if (content instanceof RChoice) {
		particles_.add(new CChoice((RChoice)content, module));
	    } else if (content instanceof REmpty) {
		particles_.add(new CEmpty((REmpty)content, module));
	    } else if (content instanceof RDatatypeRef) {
		throw (new InternalError());
	    } else if (content instanceof RAttribute) {
		throw (new InternalError());
	    } else if (content instanceof REnumeration) {
		throw (new InternalError());
	    } else if (content instanceof RLiteral) {
		throw (new InternalError());
	    } else {
		throw (new InternalError());
	    }
	}
    }

    public final void addParticle(ICParticle particle) {
	particles_.add(particle);
    }

    public final ICParticle[] getParticles() {
	ICParticle[] result = new ICParticle[particles_.size()];
	return ((ICParticle[])particles_.toArray(result));
    }
}
