/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.datatype.XMLFacet;
import jp.gr.java_conf.jaba2.xml.datatype.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.RElement;
import jp.gr.java_conf.jaba2.xml.relax.raw.RAttribute;

/**
 * CAttribute
 *
 * @since   Dec. 30, 1999
 * @version Nov.  4, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class CAttribute extends CNode implements ICPatternContent, ICParticle {
    private String name_;
    private String type_;
    private boolean required_;
    private String occurs_;
    private boolean and_;
    private String[] enumerations_;
    private String namespace_;
    private Datatype datatype_;
    private String label_;
//    private CValue value_;
//    private CRefWithPattern ref_;

    public CAttribute(String name, CModule module) {
	this(name, "string", module);
    }

    public CAttribute(String name, String type, CModule module) {
	name_ = name;
	type_ = type;
	datatype_ = module.makeDatatype(type);
    }

    public CAttribute(
	String name,
	String type,
	XMLFacet[] facets,
	CModule module
    ) {
	name_ = name;
	type_ = type;
	datatype_ = module.makeDatatype(type, facets);
    }

/*
    public CAttribute(
	String name,
	CValue value,
	CModule module
    ) {
	name_ = name;
	value_ = value;
    }

    public CAttribute(
	String name,
	CRefWithPattern ref,
	CModule module
    ) {
	name_ = name;
	ref_ = ref;
    }
*/

    public CAttribute(RAttribute rattr, CModule module) {
	super(rattr);
	name_ = rattr.getName();
	type_ = rattr.getType();
	if (type_ == null) {
	    type_ = "string";
	}
	enumerations_ = rattr.getEnumerations();
	required_ = rattr.isRequired();
	namespace_ = rattr.getNamespace();
	datatype_ = module.makeDatatype(type_, rattr.getBase());
    }

    public final void setRequired(boolean required) {
	required_ = required;
    }

    public final void setOccurs(String occurs) {
	occurs_ = occurs;
    }

    public final void setAnd(boolean and) {
	and_ = and;
    }

    public final String getName() {
	return (name_);
    }

    public final String getType() {
	return (type_);
    }

    public final boolean isRequired() {
	if (occurs_ == null) {
	    return (required_);
	} else {
	    if ("".equals(occurs_)) {
		return (true);
	    } else if ("?".equals(occurs_)) {
		return (false);
	    } else {
		throw (new InternalError());
	    }
	}
    }

    public final String getOccurs() {
	return (occurs_);
    }

    public final boolean isAnd() {
	return (and_);
    }

    public final String[] getEnumerations() {
	return (enumerations_);
    }

    public final String getNamespace() {
	return (namespace_);
    }

    public final void setNamespace(String namespace) {
	namespace_ = namespace;
    }

    public final Datatype getDatatype() {
	return (datatype_);
    }

    public final void setDatatype(Datatype datatype) {
	datatype_ = datatype;
    }

    public final String getLabel() {
	return (label_);
    }

    public final void setLabel(String label) {
	label_ = label;
    }

/*
    public final CValue getValue() {
	return (value_);
    }

    public final CRefWithPattern getRef() {
	return (ref_);
    }
*/
}
