/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.pdom;

import java.util.*;
import org.w3c.dom.*;

/**
 * PText is a DOM Node to persist.
 *
 * @since   Oct. 13, 1998
 * @version Sep. 15, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class PCharacterData extends PNode implements CharacterData {
    protected String text_;

    public PCharacterData(String text) {
	text_ = text;
    }

    public PCharacterData(String text, PNode parent) {
	super(parent);
	text_ = text;
    }

    public PCharacterData(String text, PDocument owner) {
	super(owner);
	text_ = text;
    }

    /**
     * @since REC-DOM-Level-1-19981001
     * @see org.w3c.dom.CharacterData
     */
    public String getData() throws DOMException {
	return (text_);
    }

    /**
     * @since REC-DOM-Level-1-19981001
     * @see org.w3c.dom.CharacterData
     */
    public void setData(String arg) throws DOMException {
	text_ = arg;
    }

    /**
     * @since REC-DOM-Level-1-19981001
     * @see org.w3c.dom.CharacterData
     */
    public int getLength() {
	return (text_.length());
    }

    /**
     * @since REC-DOM-Level-1-19981001
     * @see org.w3c.dom.CharacterData
     */
    public String substringData(int offset, int count) throws DOMException {
	return (text_.substring(offset, count));
    }

    /**
     * @since REC-DOM-Level-1-19981001
     * @see org.w3c.dom.CharacterData
     */
    public void appendData(String data) throws DOMException {
	text_ = text_ + data;
    }

    /**
     * @since REC-DOM-Level-1-19981001
     * @see org.w3c.dom.CharacterData
     */
    public void insertData(int offset, String data) throws DOMException {
	StringBuffer buffer = new StringBuffer();
	buffer.append(text_);
	buffer.insert(offset, data);
	text_ = buffer.toString();
    }

    /**
     * @since REC-DOM-Level-1-19981001
     * @see org.w3c.dom.CharacterData
     */
    public void deleteData(int offset, int count) throws DOMException {
	text_ = text_.substring(0, offset) + text_.substring(offset + count);
    }

    /**
     * @since REC-DOM-Level-1-19981001
     * @see org.w3c.dom.CharacterData
     */
    public void replaceData(int offset, int count, String data)
	throws DOMException {

	text_ = text_.substring(0, offset)
	    + data + text_.substring(offset + count);
    }
}
