/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

/**
 * DValue
 *
 * @since   Jul.  1, 2002
 * @version Jul.  2, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class DValue extends Datatype {
    private String[] values_;
    private Datatype type_;

    public DValue(String text) {
	values_ = new String[] { text };
	type_ = DatatypeFactory.getDatatype("token");
	if (type_ == null) {
	    throw (new InternalError());
	}
    }

    public DValue(String text, String typeName) {
	values_ = new String[] { text };
	type_ = DatatypeFactory.getDatatype(typeName);
	if (type_ == null) {
	    throw (new InternalError());
	}
    }

    public DValue(String[] values, String typeName) {
	values_ = values;
	type_ = DatatypeFactory.getDatatype(typeName);
    }

    public String getName() {
	return ("value");
    }

    public String[] getValues() {
	return (values_);
    }

    public Datatype getType() {
	return (type_);
    }

    public Object makeObject(String cdata) {
	return (cdata);
    }
}
