/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs;

import java.io.IOException;

/**
 * VFSRoot
 *
 * @since   Jan. 15, 2000
 * @version Jan. 27, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public interface IVFSRoot {
    void setRealm(IVFSRealm realm);
    void shallowSetup(IFilter filter) throws IOException;
    void deepSetup(IFilter filter) throws IOException;
    IVFSNode getNode(String name);
    void addContainer(IVFSContainer container);
    void addObject(IVFSObject object);
    IVFSObject[] getObjectChildren();
    IVFSContainer[] getContainerChildren();
}
