/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.util;

import java.util.*;

/**
 * RangeIterator
 *
 * @since   Jul. 15, 2000
 * @version Jul. 20, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RangeIterator implements Iterator {
    private int index_ = 0;
    private Iterator origin_;
    private RangeManager manager_;

    public RangeIterator(List list, String range) {
	_init(list.iterator(), range);
    }

    public RangeIterator(Iterator iter, String range) {
	_init(iter, range);
    }

    private void _init(Iterator iter, String range) {
	origin_ = iter;
	manager_ = new RangeManager(range);
    }

    public boolean hasNext() {
	while (!manager_.isValid(index_ + 1)) {
	    if (origin_.hasNext()) {
		origin_.next();
	    } else {
		return (false);
	    }
	    index_++;
	}
	return (origin_.hasNext());
    }

    public Object next() {
	index_++;
	return (origin_.next());
    }

    public void remove() {
	origin_.remove();
    }	
}
