package jp.gr.java_conf.jaba2.util;

import java.util.*;
import java.io.Serializable;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jp.gr.java_conf.jaba2.util.AbstractTreeModel;

/**
 * CollectionTreeModel
 * 
 * @since   Sep. 10, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class CollectionTreeModel extends AbstractTreeModel{
    protected Object root_;

    public CollectionTreeModel(Object root) {
	root_ = root;
    }

    // TreeModel
    public Object getRoot() {
	return (root_);
    }

    // TreeModel
    public Object getChild(Object parent, int index) {
	if (parent instanceof List) {
	    List list = (List)parent;
	    return (list.get(index));
	} else {
	    Collection collection = (Collection)parent;
	    Object[] array = collection.toArray();
	    return (array[index]);
	}
    }

    // TreeModel
    public int getChildCount(Object parent) {
	Collection collection = (Collection)parent;
	return (collection.size());
    }

    public boolean isLeaf(Object node) {
	if (node instanceof Collection) {
	    return (false);
	} else {
	    return (true);
	}
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
	// XXX
    }

    public int getIndexOfChild(Object parent, Object child) {
	if (parent instanceof List) {
	    List list = (List)parent;
	    return (list.indexOf(child));
	} else {
	    Collection collection = (Collection)parent;
	    Object[] array = collection.toArray();
	    for (int i = 0;i < array.length;i++) {
		if (child.equals(array[i])) {
		    return (i);
		}
	    }
	    return (-1);
	}
    }
}
