package jp.gr.java_conf.jaba2.text.updater.ruleR;

import org.w3c.dom.*;

/**
 * <b>Replace</b> is generated by Relaxer based on rule.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="replace" type="string">
 *   <tag>
 *     <attribute name="no" type="int"/>
 *   </tag>
 * </elementRule>
 * 
 * <tag>
 *   <attribute name="no" type="int"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="replace" type="string"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="no" type="int"/&gt;
 *   &lt;/tag&gt;
 * &lt;/elementRule&gt;
 * &lt;tag&gt;
 *   &lt;attribute name="no" type="int"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version rule.rlx (Thu Nov 09 13:17:42 JST 2000)
 * @author  Relaxer 0.11.1b (by ASAMI@Yokohama)
 */
public class Replace implements java.io.Serializable {
    private String content_;
    private Integer no_;

    /**
     * Creates a <code>Replace</code>.
     *
     */
    public Replace() {
    }

    /**
     * Creates a <code>Replace</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Replace(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Replace</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Replace(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Replace</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Replace(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>Replace</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Replace</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Replace</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IRuleFactory factory = RuleFactory.getFactory();
        RStack stack = new RStack(element);
        content_ = URelaxer.getElementPropertyAsString(element);
        no_ = URelaxer.getAttributePropertyAsIntObject(element, "no");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("replace");
        URelaxer.setElementPropertyByString(element, this.content_);
        int size;
        if (this.no_ != null) {
            URelaxer.setAttributePropertyByInt(element, "no", this.no_);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>content</b>.
     *
     * @return String
     */
    public final String getContent() {
        return (content_);
    }

    /**
     * Sets the String property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(String content) {
        this.content_ = content;
    }

    /**
     * Gets the int property <b>no</b>.
     *
     * @exception IllegalStateException
     * @return int
     */
    public int getNo() throws IllegalStateException {
        if (no_ == null) {
            throw (new IllegalStateException("no_"));
        }
        return (no_.intValue());
    }

    /**
     * Check the int property <b>no</b>.
     *
     * @return boolean
     */
    public boolean checkNo() {
        return (no_ != null);
    }

    /**
     * Sets the int property <b>no</b>.
     *
     * @param no
     */
    public void setNo(int no) {
        this.no_ = new Integer(no);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Replace</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "replace")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Replace</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Replace</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
