package jp.gr.java_conf.jaba2.text.generator;

import java.io.*;
import java.net.*;

/**
 * AbstractGeneratorModel
 *
 * @since   Feb.  5, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractGeneratorModel implements GeneratorModel {
    // Model
    public String getPrototype() {
	return (prototype_);
    }

    public void setPrototypeFromResource(String resource) {
	_setPrototypeFromResource(resource);
    }

    public void setPrototype(String prototype) {
	_setPrototypeFromString(prototype);
    }

    protected void _setPrototypeFromFile(String file) {
	InputStream in = null;
	try {
	    in = new FileInputStream(file);
	    _setPrototypeFromInputStream(in);
	} catch (IOException e) {
	    throw (new IllegalArgumentException(e.getMessage()));
	} finally {
	    try {
		if (in != null) {
		    in.close();
		}
	    } catch (IOException e ) {
	    }
	}
    }

    protected void _setPrototypeFromFile(File file) {
	InputStream in = null;
	try {
	    in = new FileInputStream(file);
	    _setPrototypeFromInputStream(in);
	} catch (IOException e) {
	    throw (new IllegalArgumentException(e.getMessage()));
	} finally {
	    try {
		if (in != null) {
		    in.close();
		}
	    } catch (IOException e ) {
	    }
	}
    }

    protected void _setPrototypeFromURL(URL url) {
	InputStream in = null;
	try {
	    in = url.openStream();
	    _setPrototypeFromInputStream(in);
	} catch (IOException e) {
	    throw (new IllegalArgumentException(e.getMessage()));
	} finally {
	    try {
		if (in != null) {
		    in.close();
		}
	    } catch (IOException e ) {
	    }
	}
    }

    protected void _setPrototypeFromResource(String resource) {
	InputStream in = null;
	in = getClass().getResourceAsStream(resource);
	if (in == null) {
	    return;
	}
	_setPrototypeFromInputStream(in);
	try {
	    in.close();
	} catch (IOException e) {
	}
    }

    protected void _setPrototypeFromInputStream(InputStream in) {
	Reader reader = null;
	StringWriter writer = null;
	try {
	    reader = new BufferedReader(new InputStreamReader(in));
	    writer = new StringWriter();
	    int c;
	    while ((c = reader.read()) != -1) {
		writer.write(c);
	    }
	    writer.flush();
	    _setPrototypeFromString(writer.toString());
	} catch (IOException e) {
	    e.printStackTrace();
	} finally {
	    if (writer != null) {
		try {
		    writer.close();
		} catch (IOException e) {
		}
	    }
	}
    }

    protected void _setPrototypeFromString(String prototype) {
	if (prototype == null) {
	    throw (new IllegalArgumentException("null string"));
	}
	prototype_ = prototype;
    }

    protected String prototype_ = null;
}
