/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.parcel;

import java.io.OutputStream;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import jp.gr.java_conf.jaba2.xml.UXML;

/**
 * DOMGadget
 *
 * @since   Oct. 17, 2000
 * @version Oct. 17, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMGadget extends AbstractGadget {
    private Document doc_;

    public DOMGadget() {
	setEncoding("UTF-8");
    }

    public void write(OutputStream out) throws IOException {
	out.write(getBytes());
    }

    public byte[] getBytes() throws IOException {
	return (getText().getBytes(getEncoding()));
    }


    public final boolean isText() {
	return (true);
    }

    public final String getText() {
	return (UXML.doc2String4Data(doc_));
    }

    public final boolean isDocument() {
	return (true);
    }

    public final Document getDocument() {
	return (doc_);
    }

    public final void setDocument(Document doc) {
	doc_ = doc;
    }
}
