package jp.gr.java_conf.jaba2.io;

import java.io.*;

/**
 * The FileFilenameFilter is a FilenameFilter to filter regular files.
 *
 * @since   Feb. 11, 1998
 * @version Apr. 27, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class FileFilenameFilter implements FilenameFilter {
    /**
     * Tests if a specified file is a regular file.
     *
     * @param dir  the direcotry in which the file was found
     * @param name  the name of the file
     * @see java.io.FilenameFilter
     */
    public boolean accept(File dir, String name) {
	return (new File(dir, name).isFile());
    }
}
