package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CContextSet</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="contextSet">
 *   <ref label="context" occurs="*"/>
 * </elementRule>
 * 
 * <tag name="contextSet"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="contextSet"&gt;
 *   &lt;ref label="context" occurs="*"/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="contextSet"/&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:14 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CContextSet implements java.io.Serializable {
    // List<CContext>
    private java.util.List context = new java.util.ArrayList();

    /**
     * Creates a <code>CContextSet</code>.
     *
     */
    public CContextSet() {
    }

    /**
     * Creates a <code>CContextSet</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CContextSet(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CContextSet</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CContextSet(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CContextSet</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CContextSet(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CContextSet</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CContextSet</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CContextSet</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        context.clear();
        while (!stack.isEmptyElement()) {
            if (CContext.isMatch(stack)) {
                addContext(factory.createCContext(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("contextSet");
        int size;
        size = context.size();
        for (int i = 0;i < size;i++) {
            CContext value = (CContext)this.context.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the CContext property <b>context</b>.
     *
     * @return CContext[]
     */
    public final CContext[] getContext() {
        CContext[] array = new CContext[context.size()];
        return ((CContext[])context.toArray(array));
    }

    /**
     * Sets the CContext property <b>context</b>.
     *
     * @param context
     */
    public final void setContext(CContext[] context) {
        this.context.clear();
        this.context.addAll(java.util.Arrays.asList(context));
    }

    /**
     * Adds the CContext property <b>context</b>.
     *
     * @param context
     */
    public final void addContext(CContext context) {
        this.context.add(context);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CContextSet</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"contextSet".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!CContext.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CContextSet</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CContextSet</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
