/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.model;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * FrameRubberBandModel
 *
 * @since   Mar.  5, 1999
 * @version Mar.  5, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class FrameRubberBandModel extends AbstractRubberBandModel {
    public boolean isStartDragging(Point point) {
	return (true);
    }

    public void stopDragging(Point base, Point current) {
    }

    // Model
    public Rectangle paint(Graphics g, Point base, Point current) {
	int x = Math.min(base.x, current.x);
	int y = Math.min(base.y, current.y);
	int width = Math.abs(base.x - current.x);
	int height = Math.abs(base.y - current.y);
	g.setColor(Color.black);
	g.drawRect(x, y, width - 1, height - 1);
	return (new Rectangle(x, y, width, height));
    }
}
