/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1998  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.Color;
import javax.swing.*;

/**
 * GraphNode
 *
 * @since   Nov. 13, 1998
 * @version Dec. 24, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class GraphNode extends AbstractGraphObject {
    protected List links_ = new ArrayList(); // List<GrapLink>
    protected GraphDock dock_ = null;

    public GraphNode() {
    }

    public GraphNode(GraphModel model) {
	super(model);
    }

    public void addLink(GraphLink link) {
	links_.add(link);
    }

    public void removeLink(GraphLink link) {
	links_.remove(link);
    }

    public GraphLink[] getLinks() {
	GraphLink[] links = new GraphLink[links_.size()];
	return ((GraphLink[])links_.toArray(links));
    }

    public GraphNode[] getLinkNodes() {
	List list = new ArrayList();
	int size = links_.size();
	for (int i = 0;i < size;i++) {
	    GraphLink link = (GraphLink)links_.get(i);
	    GraphNode[] links = link.getLinkNodes(this);
	    for (int j = 0;j < links.length;j++) {
		list.add(links[j]);
	    }
	}
	GraphNode[] array = new GraphNode[list.size()];
	return ((GraphNode[])list.toArray(array));
    }

    public void setDock(GraphDock dock) {
	dock_ = dock;
    }

    public GraphDock getDock() {
	return (dock_);
    }

    public Rectangle getRepaintBounds() {
	int size;
	size = links_.size();
	if (size > 0) {
	    Rectangle bounds = null;
	    GraphLink link;
	    link = (GraphLink)links_.get(0);
	    bounds = link.getRepaintBounds();
	    for (int i = 1;i < size;i++) {
		link = (GraphLink)links_.get(i);
		bounds = bounds.union(link.getRepaintBounds());
	    }
	    return (bounds);
	} else {
	    return (new Rectangle(0, 0, 0, 0));
	}
    }
}
