package jp.gr.java_conf.jaba2.awt;

import java.util.*;
import java.awt.LayoutManager2;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Dimension;
import java.awt.Rectangle;

/**
 * ExplorerLayout
 *
 * @since   Apr.  3, 1998
 * @version Oct. 13, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ExplorerLayout extends AbstractLayoutManager {
    protected Component list_ = new NullComponent();
    protected Component tree_ = null;
    protected Component summary_ = null;
    protected Component view_ = new NullComponent();

    public ExplorerLayout() {
	super(3, 3, 3, 3);
    }

    // AbstractLayoutManager
    public void addLayoutComponent(Component comp, Object constraints) {
//System.out.println(comp);
	try {
	    String place = (String)constraints;
//System.out.println(place);
	    if (place.equals("list")) {
		list_ = comp;
	    } else if (place.equals("tree")) {
		tree_ = comp;
	    } else if (place.equals("summary")) {
		summary_ = comp;
	    } else if (place.equals("view")) {
		view_ = comp;
	    } else {
		throw (new Exception());
	    }
	} catch (Exception evt) {
	    throw (new IllegalArgumentException(
		"Invalid constraints : " + constraints
	    ));
	}
	super.addLayoutComponent(comp, constraints);
    }

    // LayoutManager
    public void layoutContainer(Container parent) {
//System.out.println("layoutContainer");
	if (tree_ == null) {
	    return;
	}
	Dimension areaSize = _getViewSize(parent);
	Insets insets = parent.getInsets();
	Dimension listPref = list_.getPreferredSize();
	Dimension treePref = tree_.getPreferredSize();
	Dimension summaryPref = summary_.getPreferredSize();
	Dimension viewPref = view_.getPreferredSize();
	Rectangle listArea = new Rectangle();
	Rectangle treeArea = new Rectangle();
	Rectangle summaryArea = new Rectangle();
	Rectangle viewArea = new Rectangle();
	int leftWidth = Math.max(listPref.width, treePref.width);
	int rightWidth = areaSize.width - leftWidth - hInnerGap_;
	if (rightWidth < 0) {
	    rightWidth = 0;
	}
	int leftInnerGap = listPref.height > 0 ? vInnerGap_ : 0;
	int rightInnerGap = viewPref.height > 0 ? vInnerGap_ : 0;
	listArea.x = 0;
	listArea.y = 0;
	listArea.width = leftWidth;
	listArea.height = listPref.height;
	treeArea.x = listArea.x;
	treeArea.y = listArea.y + listArea.height + leftInnerGap;
	treeArea.width = leftWidth;
	treeArea.height = areaSize.height - listArea.height;
	if (treeArea.height < 0) {
	    treeArea.height = 0;
	}
	int summaryHeight;
	int viewHeight;
	if (viewPref.height == 0) {
	    summaryHeight = areaSize.height;
	    viewHeight = 0;
	} else {
	    summaryHeight = (areaSize.height - rightInnerGap) * 3 / 10;
	    viewHeight = areaSize.height - rightInnerGap - summaryHeight;
	}
	summaryArea.x = listArea.x + treeArea.width + hInnerGap_;
	summaryArea.y = listArea.y;
	summaryArea.width = rightWidth;
	summaryArea.height = summaryHeight;
	viewArea.x = summaryArea.x;
	viewArea.y = summaryArea.y + summaryArea.height + rightInnerGap;
	viewArea.width = rightWidth;
	viewArea.height = viewHeight;
	List areas = new ArrayList();
	areas.add(listArea);
	areas.add(treeArea);
	areas.add(summaryArea);
	areas.add(viewArea);
//System.out.println(areas);
	List comps = new ArrayList();
	comps.add(list_);
	comps.add(tree_);
	comps.add(summary_);
	comps.add(view_);
	_moveComponentsOnView(comps, areas, insets);
    }

    // LayoutManager
    public Dimension preferredLayoutSize(Container parent) {
	if (tree_ == null) {
	    return (new Dimension(0, 0));
	}
	Dimension listPref = list_.getPreferredSize();
	Dimension treePref = tree_.getPreferredSize();
	Dimension summaryPref = summary_.getPreferredSize();
	Dimension viewPref = view_.getPreferredSize();
	int leftInnerGap = listPref.height > 0 ? vInnerGap_ : 0;
	int rightInngerGap = viewPref.height > 0 ? vInnerGap_ : 0;
	Dimension dim = new Dimension(
	    Math.max(listPref.width, treePref.width) +
	    hInnerGap_ +
	    Math.max(summaryPref.width, viewPref.width),
	    Math.max(listPref.height + treePref.height + vInnerGap_,
		     ((viewPref.height * 10) / 7) + vInnerGap_)
	);
	_adjustBorder(dim, parent.getInsets());
	return (dim);
    }

    // LayoutManager
    public Dimension minimumLayoutSize(Container parent) {
	return (preferredLayoutSize(parent));
    }

    // test driver
    public static void main(String[] args) {
	javax.swing.JFrame frame
	    = new javax.swing.JFrame("ExplorerLayout test");
	frame.addWindowListener(
	    new jp.gr.java_conf.jaba2.awt.ExitWhenWindowClosing()
	);
	javax.swing.JPanel panel = new javax.swing.JPanel();
	panel.setLayout(new ExplorerLayout());
	panel.add(new javax.swing.JLabel("LIST"), "list");
	panel.add(
	    new javax.swing.JScrollPane(
		new javax.swing.JTree()
	    ),
	    "tree"
	);
	panel.add(new javax.swing.JButton("summary"), "summary");
	panel.add(new javax.swing.JButton("view"), "view");
	frame.getContentPane().add(panel);
	frame.pack();
	frame.show();
    }
}
