/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * MutableTabularDecorator
 *
 * @since   Jul. 11, 2001
 * @version Aug. 13, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class MutableTabularDecorator extends TabularDecorator
    implements IMutableTabular {

    private IMutableTabular mutableTabular_;

    protected void _setup(IMutableTabular tabular) {
	super._setup(tabular);
	mutableTabular_ = tabular;
    }

    public void setName(String name) {
	mutableTabular_.setName(name);
    }

    public void setLabel(int x, String label) {
	mutableTabular_.setLabel(x, label);
    }

    public void set(int x, int y, Object data) {
	mutableTabular_.set(x, y, data);
    }

    public void set(Document doc) {
	mutableTabular_.set(doc);
    }

    public void set(Element element) {
	mutableTabular_.set(element);
    }

    public void add(Document doc) {
	mutableTabular_.add(doc);
    }

    public void add(Element element) {
	mutableTabular_.add(element);
    }

    public void clearData() {
	mutableTabular_.clearData();
    }
}
