package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FComponentProviderGateway</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="gateway">
 *   <choice>
 *     <element name="name">
 *       <data type="token"/>
 *     </element>
 *     <element name="className">
 *       <data type="token"/>
 *     </element>
 *   </choice>
 *   <zeroOrMore>
 *     <ref name="property"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="gateway"&gt;
 *   &lt;choice&gt;
 *     &lt;element name="name"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/element&gt;
 *     &lt;element name="className"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/element&gt;
 *   &lt;/choice&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="property"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Sat Aug 24 15:59:09 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class FComponentProviderGateway implements java.io.Serializable {
    private IFComponentProviderGatewayChoice content_;
    // List<FProperty>
    private java.util.List property_ = new java.util.ArrayList();

    /**
     * Creates a <code>FComponentProviderGateway</code>.
     *
     */
    public FComponentProviderGateway() {
    }

    /**
     * Creates a <code>FComponentProviderGateway</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FComponentProviderGateway(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FComponentProviderGateway</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FComponentProviderGateway(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FComponentProviderGateway</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FComponentProviderGateway(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FComponentProviderGateway</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentProviderGateway(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FComponentProviderGateway</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentProviderGateway(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FComponentProviderGateway</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentProviderGateway(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FComponentProviderGateway</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentProviderGateway(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FComponentProviderGateway</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentProviderGateway(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FComponentProviderGateway</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentProviderGateway(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        if (FComponentProviderGatewayName.isMatch(stack)) {
            setContent(new FComponentProviderGatewayName(stack));
        } else if (FComponentProviderGatewayClassName.isMatch(stack)) {
            setContent(new FComponentProviderGatewayClassName(stack));
        } else {
            throw (new IllegalArgumentException());
        }
        property_.clear();
        while (!stack.isEmptyElement()) {
            if (FProperty.isMatch(stack)) {
                addProperty(new FProperty(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("gateway");
        int size;
        this.content_.makeElement(element);
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentProviderGateway</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the IFComponentProviderGatewayChoice property <b>content</b>.
     *
     * @return IFComponentProviderGatewayChoice
     */
    public final IFComponentProviderGatewayChoice getContent() {
        return (content_);
    }

    /**
     * Sets the IFComponentProviderGatewayChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IFComponentProviderGatewayChoice content) {
        this.content_ = content;
    }

    /**
     * Gets the FProperty property <b>property</b>.
     *
     * @return FProperty[]
     */
    public final FProperty[] getProperty() {
        FProperty[] array = new FProperty[property_.size()];
        return ((FProperty[])property_.toArray(array));
    }

    /**
     * Sets the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void setProperty(FProperty[] property) {
        this.property_.clear();
        this.property_.addAll(java.util.Arrays.asList(property));
    }

    /**
     * Sets the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void setProperty(FProperty property) {
        this.property_.clear();
        this.property_.add(property);
    }

    /**
     * Adds the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void addProperty(FProperty property) {
        this.property_.add(property);
    }

    /**
     * Gets number of the FProperty property <b>property</b>.
     *
     * @return int
     */
    public final int getPropertyCount() {
        return (property_.size());
    }

    /**
     * Gets the FProperty property <b>property</b> by index.
     *
     * @param index
     * @return FProperty
     */
    public final FProperty getProperty(int index) {
        return ((FProperty)property_.get(index));
    }

    /**
     * Sets the FProperty property <b>property</b> by index.
     *
     * @param index
     * @param property
     */
    public final void setProperty(int index, FProperty property) {
        this.property_.set(index, property);
    }

    /**
     * Adds the FProperty property <b>property</b> by index.
     *
     * @param index
     * @param property
     */
    public final void addProperty(int index, FProperty property) {
        this.property_.add(index, property);
    }

    /**
     * Remove the FProperty property <b>property</b> by index.
     *
     * @param index
     */
    public final void removeProperty(int index) {
        property_.remove(index);
    }

    /**
     * Remove the FProperty property <b>property</b> by object.
     *
     * @param property
     */
    public final void removeProperty(FProperty property) {
        this.property_.remove(property);
    }

    /**
     * Clear the FProperty property <b>property</b>.
     *
     */
    public final void clearProperty() {
        property_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<gateway");
        buffer.append(">");
        content_.makeTextElement(buffer);
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</gateway>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<gateway");
        buffer.print(">");
        content_.makeTextElement(buffer);
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</gateway>");
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FComponentProviderGateway</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "gateway")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (FComponentProviderGatewayName.isMatchHungry(target)) {
            $match$ = true;
        } else if (FComponentProviderGatewayClassName.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (!target.isEmptyElement()) {
            if (!FProperty.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FComponentProviderGateway</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FComponentProviderGateway</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
