/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.runtime.logger;

import java.util.*;
import java.io.*;
import org.relaxer.runtime.*;

/**
 * AbstractPrintStreamLogger
 *
 * @since   Apr. 12, 2002
 * @version Apr. 12, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public abstract class AbstractStreamLogger extends AbstractLogger {
    protected PrintWriter out_;

    protected AbstractStreamLogger() {
    }

    protected AbstractStreamLogger(PrintWriter out) {
	_setup(out);
    }

    protected AbstractStreamLogger(Writer out) {
	_setup(out);
    }

    protected AbstractStreamLogger(OutputStream out) {
	_setup(out);
    }

    protected void _setup(PrintWriter out) {
	out_ = out;
    }

    protected void _setup(Writer out) {
	out_ = new PrintWriter(out);
    }

    protected void _setup(OutputStream out) {
	out_ = new PrintWriter(out);
    }
}
