/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.runtime;

import java.io.StringReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.relaxer.runtime.rRuntime.*;

/**
 * RRuntimeContext
 *
 * @since   Aug. 22, 2002
 * @version Aug. 23, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RRuntimeContext {
    private RRRuntime rrRuntime_;

    public RRuntimeContext(String xml)
	throws IOException, SAXException, ParserConfigurationException {

	rrRuntime_ = new RRRuntime(new StringReader(xml));
    }

    public RRuntimeContext(RRRuntime rrRuntime) {
	rrRuntime_ = rrRuntime;
    }

    public String toString() {
	return (getXml());
    }

    public String getXml() {
	return (rrRuntime_.makeTextDocument());
    }

    public Object getAppPrincipal() {
	return (null);
    }

    public Object getAppSession() {
	return (null);
    }

    public RRRuntime getRRRuntime() {
	return (rrRuntime_);
    }

    public RRPrincipal getRRPrincipal() {
	return (rrRuntime_.getPrincipal());
    }

    public RRSession getRRSession() {
	return (rrRuntime_.getSession());
    }
}
