/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.parcel;

import java.util.*;

/**
 * SimpleParcel
 *
 * @since   Aug. 24, 2000
 * @version Feb. 25, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class SimpleParcel extends AbstractParcel {
    private List gadgets_ = new ArrayList(); // IGadget

    public void addGadget(IGadget gadget) {
	gadgets_.add(gadget);
	gadget.setOwnerParcel(this);
    }

    public int nGadgets() {
	return (gadgets_.size());
    }

    public IGadget getGadget(int index) {
	return ((IGadget)gadgets_.get(index));
    }

    public IGadget[] getGadgets() {
	IGadget[] gadget = new IGadget[gadgets_.size()];
	return ((IGadget[])gadgets_.toArray(gadget));
    }

    public String[] getPathNames() {
	int size = gadgets_.size();
	String[] names = new String[size];
	for (int i = 0;i < size;i++) {
	    IGadget gadget = (IGadget)gadgets_.get(i);
	    names[i] = gadget.getName();
	}
	return (names);
    }

    public IGadget getGadget(String pathName) {
	int size = gadgets_.size();
	String[] names = new String[size];
	for (int i = 0;i < size;i++) {
	    IGadget gadget = (IGadget)gadgets_.get(i);
	    if (pathName.equals(gadget.getName())) {
		return (gadget);
	    }
	}
	return (null);
    }
}
