/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.parcel;

import java.util.*;
import java.io.OutputStream;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;

/**
 * AbstractGadget
 *
 * @since   Aug. 24, 2000
 * @version Feb. 25, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractGadget extends AbstractPropertyContainer
    implements IGadget {

    private IParcel owner_;
    private String name_;
    private String encoding_ = "UTF-8";
    private String mimeType_;

    public final void setOwnerParcel(IParcel parcel) {
	owner_ = parcel;
    }

    public final IParcel getOwnerParcel() {
	return (owner_);
    }

    public final void setName(String name) {
	name_ = name;
    }

    public final String getName() {
	return (name_);
    }

    public final void setEncoding(String encoding) {
	encoding_ = encoding;
    }

    public final String getEncoding() {
	return (encoding_);
    }

    public final void setMIMEType(String mimeType) {
	mimeType_ = mimeType;
    }

    public final String getMIMEType() {
	return (mimeType_);
    }

    public boolean isText() {
	return (false);
    }

    public String getText() throws IOException {
	throw (new UnsupportedOperationException());
    }

    public boolean isDocument() {
	return (false);
    }

    public Document getDocument() throws IOException, SAXException {
	throw (new UnsupportedOperationException());
    }
}
