package org.relaxer.dialog.rDialog;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * IDialogFactory is generated by Relaxer based on dialog.rng.
 *
 * @version dialog.rng 1.0 (Wed Feb 27 11:01:28 JST 2002)
 * @author  Relaxer 0.16.1b (http://www.relaxer.org)
 */
public interface IDialogFactory {
    /**
     * Sets a error handler to handle parsing error.
     *
     * @param handler
     */
    void setErrorHandler(org.xml.sax.ErrorHandler handler);

    /**
     * Creates a <code>DDialog</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    DDialog createDDialog(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSlot</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    DSlot createDSlot(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DRead</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    DRead createDRead(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJdbc</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    DJdbc createDJdbc(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxm</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    DJaxm createDJaxm(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBean</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    DBean createDBean(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DFile</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    DFile createDFile(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJms</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    DJms createDJms(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DWrite</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    DWrite createDWrite(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DReadWrite</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCommand</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    DCommand createDCommand(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbAction</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbMethod</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbParam</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBeanAction</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericMethod</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericParam</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSwitch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    DSwitch createDSwitch(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCase</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    DCase createDCase(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxmAction</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DDialog</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    DDialog createDDialog(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSlot</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    DSlot createDSlot(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DRead</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    DRead createDRead(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJdbc</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    DJdbc createDJdbc(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxm</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    DJaxm createDJaxm(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBean</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    DBean createDBean(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DFile</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    DFile createDFile(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJms</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    DJms createDJms(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DWrite</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    DWrite createDWrite(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DReadWrite</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCommand</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    DCommand createDCommand(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbAction</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbMethod</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbParam</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBeanAction</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericMethod</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericParam</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSwitch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    DSwitch createDSwitch(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCase</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    DCase createDCase(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxmAction</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DDialog</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    DDialog createDDialog(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSlot</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    DSlot createDSlot(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DRead</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    DRead createDRead(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJdbc</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    DJdbc createDJdbc(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxm</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    DJaxm createDJaxm(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBean</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    DBean createDBean(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DFile</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    DFile createDFile(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJms</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    DJms createDJms(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DWrite</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    DWrite createDWrite(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DReadWrite</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCommand</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    DCommand createDCommand(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbAction</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbMethod</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbParam</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBeanAction</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericMethod</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericParam</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSwitch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    DSwitch createDSwitch(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCase</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    DCase createDCase(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxmAction</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DDialog</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    DDialog createDDialog(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSlot</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    DSlot createDSlot(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DRead</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    DRead createDRead(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJdbc</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    DJdbc createDJdbc(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxm</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    DJaxm createDJaxm(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBean</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    DBean createDBean(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DFile</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    DFile createDFile(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJms</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    DJms createDJms(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DWrite</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    DWrite createDWrite(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DReadWrite</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCommand</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    DCommand createDCommand(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbAction</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbMethod</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbParam</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBeanAction</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericMethod</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericParam</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSwitch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    DSwitch createDSwitch(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCase</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    DCase createDCase(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxmAction</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DDialog</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    DDialog createDDialog(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSlot</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    DSlot createDSlot(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DRead</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    DRead createDRead(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJdbc</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    DJdbc createDJdbc(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxm</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    DJaxm createDJaxm(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBean</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    DBean createDBean(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DFile</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    DFile createDFile(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJms</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    DJms createDJms(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DWrite</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    DWrite createDWrite(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DReadWrite</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCommand</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    DCommand createDCommand(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbAction</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbMethod</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbParam</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBeanAction</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericMethod</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericParam</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSwitch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    DSwitch createDSwitch(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCase</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    DCase createDCase(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxmAction</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DDialog</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    DDialog createDDialog(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSlot</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    DSlot createDSlot(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DRead</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    DRead createDRead(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJdbc</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    DJdbc createDJdbc(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxm</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    DJaxm createDJaxm(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBean</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    DBean createDBean(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DFile</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    DFile createDFile(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJms</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    DJms createDJms(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DWrite</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    DWrite createDWrite(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DReadWrite</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCommand</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    DCommand createDCommand(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbAction</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbMethod</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DEjbParam</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DBeanAction</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericMethod</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DGenericParam</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DSwitch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    DSwitch createDSwitch(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DCase</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    DCase createDCase(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DJaxmAction</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>DDialog</code>.
     *
     * @return DDialog
     */
    DDialog createDDialog();

    /**
     * Creates a <code>DSlot</code>.
     *
     * @return DSlot
     */
    DSlot createDSlot();

    /**
     * Creates a <code>DRead</code>.
     *
     * @return DRead
     */
    DRead createDRead();

    /**
     * Creates a <code>DJdbc</code>.
     *
     * @return DJdbc
     */
    DJdbc createDJdbc();

    /**
     * Creates a <code>DJaxm</code>.
     *
     * @return DJaxm
     */
    DJaxm createDJaxm();

    /**
     * Creates a <code>DBean</code>.
     *
     * @return DBean
     */
    DBean createDBean();

    /**
     * Creates a <code>DFile</code>.
     *
     * @return DFile
     */
    DFile createDFile();

    /**
     * Creates a <code>DJms</code>.
     *
     * @return DJms
     */
    DJms createDJms();

    /**
     * Creates a <code>DWrite</code>.
     *
     * @return DWrite
     */
    DWrite createDWrite();

    /**
     * Creates a <code>DReadWrite</code>.
     *
     * @return DReadWrite
     */
    DReadWrite createDReadWrite();

    /**
     * Creates a <code>DCommand</code>.
     *
     * @return DCommand
     */
    DCommand createDCommand();

    /**
     * Creates a <code>DEjbAction</code>.
     *
     * @return DEjbAction
     */
    DEjbAction createDEjbAction();

    /**
     * Creates a <code>DEjbMethod</code>.
     *
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod();

    /**
     * Creates a <code>DEjbParam</code>.
     *
     * @return DEjbParam
     */
    DEjbParam createDEjbParam();

    /**
     * Creates a <code>DBeanAction</code>.
     *
     * @return DBeanAction
     */
    DBeanAction createDBeanAction();

    /**
     * Creates a <code>DGenericMethod</code>.
     *
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod();

    /**
     * Creates a <code>DGenericParam</code>.
     *
     * @return DGenericParam
     */
    DGenericParam createDGenericParam();

    /**
     * Creates a <code>DSwitch</code>.
     *
     * @return DSwitch
     */
    DSwitch createDSwitch();

    /**
     * Creates a <code>DCase</code>.
     *
     * @return DCase
     */
    DCase createDCase();

    /**
     * Creates a <code>DJaxmAction</code>.
     *
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction();

    /**
     * Creates a <code>DDialog</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DDialog
     */
    DDialog createDDialog(Document doc);

    /**
     * Creates a <code>DSlot</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DSlot
     */
    DSlot createDSlot(Document doc);

    /**
     * Creates a <code>DRead</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DRead
     */
    DRead createDRead(Document doc);

    /**
     * Creates a <code>DJdbc</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DJdbc
     */
    DJdbc createDJdbc(Document doc);

    /**
     * Creates a <code>DJaxm</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DJaxm
     */
    DJaxm createDJaxm(Document doc);

    /**
     * Creates a <code>DBean</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DBean
     */
    DBean createDBean(Document doc);

    /**
     * Creates a <code>DFile</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DFile
     */
    DFile createDFile(Document doc);

    /**
     * Creates a <code>DJms</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DJms
     */
    DJms createDJms(Document doc);

    /**
     * Creates a <code>DWrite</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DWrite
     */
    DWrite createDWrite(Document doc);

    /**
     * Creates a <code>DReadWrite</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(Document doc);

    /**
     * Creates a <code>DCommand</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DCommand
     */
    DCommand createDCommand(Document doc);

    /**
     * Creates a <code>DEjbAction</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(Document doc);

    /**
     * Creates a <code>DEjbMethod</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(Document doc);

    /**
     * Creates a <code>DEjbParam</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(Document doc);

    /**
     * Creates a <code>DBeanAction</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(Document doc);

    /**
     * Creates a <code>DGenericMethod</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(Document doc);

    /**
     * Creates a <code>DGenericParam</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(Document doc);

    /**
     * Creates a <code>DSwitch</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DSwitch
     */
    DSwitch createDSwitch(Document doc);

    /**
     * Creates a <code>DCase</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DCase
     */
    DCase createDCase(Document doc);

    /**
     * Creates a <code>DJaxmAction</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(Document doc);

    /**
     * Creates a <code>DDialog</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DDialog
     */
    DDialog createDDialog(Element element);

    /**
     * Creates a <code>DSlot</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DSlot
     */
    DSlot createDSlot(Element element);

    /**
     * Creates a <code>DRead</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DRead
     */
    DRead createDRead(Element element);

    /**
     * Creates a <code>DJdbc</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DJdbc
     */
    DJdbc createDJdbc(Element element);

    /**
     * Creates a <code>DJaxm</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DJaxm
     */
    DJaxm createDJaxm(Element element);

    /**
     * Creates a <code>DBean</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DBean
     */
    DBean createDBean(Element element);

    /**
     * Creates a <code>DFile</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DFile
     */
    DFile createDFile(Element element);

    /**
     * Creates a <code>DJms</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DJms
     */
    DJms createDJms(Element element);

    /**
     * Creates a <code>DWrite</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DWrite
     */
    DWrite createDWrite(Element element);

    /**
     * Creates a <code>DReadWrite</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(Element element);

    /**
     * Creates a <code>DCommand</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DCommand
     */
    DCommand createDCommand(Element element);

    /**
     * Creates a <code>DEjbAction</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(Element element);

    /**
     * Creates a <code>DEjbMethod</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(Element element);

    /**
     * Creates a <code>DEjbParam</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(Element element);

    /**
     * Creates a <code>DBeanAction</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(Element element);

    /**
     * Creates a <code>DGenericMethod</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(Element element);

    /**
     * Creates a <code>DGenericParam</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(Element element);

    /**
     * Creates a <code>DSwitch</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DSwitch
     */
    DSwitch createDSwitch(Element element);

    /**
     * Creates a <code>DCase</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DCase
     */
    DCase createDCase(Element element);

    /**
     * Creates a <code>DJaxmAction</code> by the Element <code>element</code>.
     *
     * @param element
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(Element element);

    /**
     * Creates a <code>DDialog</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DDialog
     */
    DDialog createDDialog(RStack stack);

    /**
     * Creates a <code>DSlot</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DSlot
     */
    DSlot createDSlot(RStack stack);

    /**
     * Creates a <code>DRead</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DRead
     */
    DRead createDRead(RStack stack);

    /**
     * Creates a <code>DJdbc</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DJdbc
     */
    DJdbc createDJdbc(RStack stack);

    /**
     * Creates a <code>DJaxm</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DJaxm
     */
    DJaxm createDJaxm(RStack stack);

    /**
     * Creates a <code>DBean</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DBean
     */
    DBean createDBean(RStack stack);

    /**
     * Creates a <code>DFile</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DFile
     */
    DFile createDFile(RStack stack);

    /**
     * Creates a <code>DJms</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DJms
     */
    DJms createDJms(RStack stack);

    /**
     * Creates a <code>DWrite</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DWrite
     */
    DWrite createDWrite(RStack stack);

    /**
     * Creates a <code>DReadWrite</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DReadWrite
     */
    DReadWrite createDReadWrite(RStack stack);

    /**
     * Creates a <code>DCommand</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DCommand
     */
    DCommand createDCommand(RStack stack);

    /**
     * Creates a <code>DEjbAction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DEjbAction
     */
    DEjbAction createDEjbAction(RStack stack);

    /**
     * Creates a <code>DEjbMethod</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DEjbMethod
     */
    DEjbMethod createDEjbMethod(RStack stack);

    /**
     * Creates a <code>DEjbParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DEjbParam
     */
    DEjbParam createDEjbParam(RStack stack);

    /**
     * Creates a <code>DBeanAction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DBeanAction
     */
    DBeanAction createDBeanAction(RStack stack);

    /**
     * Creates a <code>DGenericMethod</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DGenericMethod
     */
    DGenericMethod createDGenericMethod(RStack stack);

    /**
     * Creates a <code>DGenericParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DGenericParam
     */
    DGenericParam createDGenericParam(RStack stack);

    /**
     * Creates a <code>DSwitch</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DSwitch
     */
    DSwitch createDSwitch(RStack stack);

    /**
     * Creates a <code>DCase</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DCase
     */
    DCase createDCase(RStack stack);

    /**
     * Creates a <code>DJaxmAction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DJaxmAction
     */
    DJaxmAction createDJaxmAction(RStack stack);

    /**
     * Creates a <code>DReadAndWrite</code> by the Element <code>element</code>.
     *
     * @return DReadAndWrite
     */
    DReadAndWrite createDReadAndWrite();

    /**
     * Creates a <code>DReadAndWrite</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return DReadAndWrite
     */
    DReadAndWrite createDReadAndWrite(RStack stack);
}
