package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DWrite</b> is generated by Relaxer based on dialog.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="write">
 *   <ref name="accessMethod"/>
 * </element>
 * 
 * <element name="write">
 *   <ref name="accessMethod"/>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="write"&gt;
 *   &lt;ref name="accessMethod"/&gt;
 * &lt;/element&gt;
 * &lt;element name="write"&gt;
 *   &lt;ref name="accessMethod"/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version dialog.rng (Wed Feb 27 11:01:27 JST 2002)
 * @author  Relaxer 0.16.1b (http://www.relaxer.org)
 */
public class DWrite implements java.io.Serializable, IREvaluatable, IRNode, IDSlotChoice {
    private IDAccessMethodChoice accessMethod_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>DWrite</code>.
     *
     */
    public DWrite() {
    }

    /**
     * Creates a <code>DWrite</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DWrite(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>DWrite</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public DWrite(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>DWrite</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public DWrite(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>DWrite</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DWrite(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>DWrite</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DWrite(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>DWrite</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DWrite(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>DWrite</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DWrite(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>DWrite</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DWrite(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>DWrite</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DWrite(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>DWrite</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>DWrite</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>DWrite</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IDialogFactory factory = DialogFactory.getFactory();
        RStack stack = new RStack(element);
        if (DJdbc.isMatch(stack)) {
            setAccessMethod(factory.createDJdbc(stack));
        } else if (DJaxm.isMatch(stack)) {
            setAccessMethod(factory.createDJaxm(stack));
        } else if (DBean.isMatch(stack)) {
            setAccessMethod(factory.createDBean(stack));
        } else if (DFile.isMatch(stack)) {
            setAccessMethod(factory.createDFile(stack));
        } else if (DJms.isMatch(stack)) {
            setAccessMethod(factory.createDJms(stack));
        } else {
            throw (new IllegalArgumentException());
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("write");
        int size;
        this.accessMethod_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>DWrite</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>DWrite</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DWrite</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DWrite</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DWrite</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DWrite</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the IDAccessMethodChoice property <b>accessMethod</b>.
     *
     * @return IDAccessMethodChoice
     */
    public final IDAccessMethodChoice getAccessMethod() {
        return (accessMethod_);
    }

    /**
     * Sets the IDAccessMethodChoice property <b>accessMethod</b>.
     *
     * @param accessMethod
     */
    public final void setAccessMethod(IDAccessMethodChoice accessMethod) {
        this.accessMethod_ = accessMethod;
        if (accessMethod != null) {
            accessMethod.setParentRNode(this);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<write");
        buffer.append(">");
        accessMethod_.makeTextElement(buffer);
        buffer.append("</write>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<write");
        buffer.print(">");
        accessMethod_.makeTextElement(buffer);
        buffer.print("</write>");
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = getRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.add(accessMethod_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>DWrite</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "write")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (DJdbc.isMatchHungry(target)) {
        } else if (DJaxm.isMatchHungry(target)) {
        } else if (DBean.isMatchHungry(target)) {
        } else if (DFile.isMatchHungry(target)) {
        } else if (DJms.isMatchHungry(target)) {
        } else {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DWrite</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DWrite</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
