/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus.model;

import java.util.*;
import org.relaxer.bus.*;

/**
 * AbstractRBusFramework
 *
 * @since   Jan.  1, 2002
 * @version Jan.  1, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public abstract class AbstractRBusFramework extends AbstractRBusPart
    implements IRBusFramework {

    // List<IRBusPart>
    private List parts_ = new ArrayList();
    private Map roles_ = new HashMap();

    public void setup(IRBusProperties properties) {
	int size = parts_.size();
	for (int i = 0;i < size;i++) {
	    IRBusPart part = (IRBusPart)parts_.get(i);
	    part.setup(properties);
	}
    }

    public void addPart(IRBusPart part) {
	parts_.add(part);
    }

    public IRBusPart[] getParts() {
	IRBusPart[] parts = new IRBusPart[parts_.size()];
	return ((IRBusPart[])parts_.toArray(parts));
    }

    public int partCount() {
	return (parts_.size());
    }

    public IRBusPart getPart(int index) {
	return ((IRBusPart)parts_.get(index));
    }

    public void addPart(String role, IRBusPart part) {
	List list = (List)roles_.get(role);
	if (list == null) {
	    list = new ArrayList();
	    roles_.put(role, list);
	}
	list.add(part);
    }

    public IRBusPart getPart(String role) {
	List list = (List)roles_.get(role);
	if (list == null) {
	    return (null);
	}
	return ((IRBusPart)list.get(0));
    }

    public IRBusPart[] getParts(String role) {
	List list = (List)roles_.get(role);
	if (list == null) {
	    return (null);
	}
	IRBusPart[] parts = new IRBusPart[list.size()];
	return ((IRBusPart[])list.toArray(parts));
    }
}
