/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * RJDBCUpdateBean
 *
 * @since   Feb.  1, 2001
 * @version Jun. 10, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RJDBCUpdateBean extends AbstractRJDBCBean {
    public void updateRObject(Object rObject) throws SQLException {
	Object handle = _makeHandle();
	_updateObject(handle, rObject);
	_closeHandle(handle);
    }

    private void _updateObject(
	Object handle,
	Object rObject
    ) throws SQLException {
	try {
	    Class[] types = { rObject.getClass() };
	    Method method = handle.getClass().getMethod("update", types);
	    Object[] params = { rObject };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
	    throw (_makeSQLException(e));
	} 
    }
}
