/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import org.relaxer.tabular.ITabular;
import org.relaxer.dialog.*;
import org.relaxer.dialog.rDialog.DialogFactory;
import org.relaxer.dialog.eDialog.EvalDialogFactory;

/**
 * DialogSpaceBean
 *
 * @since   Jul. 10, 2001
 * @version Feb. 27, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class DialogSpaceBean implements Serializable {
    transient private IDialogSpace space_;
    private String uri_;

    public DialogSpaceBean() {
    }

    public DialogSpaceBean(String uri)
	throws IOException,
	       ClassNotFoundException,
	       SAXException,
	       ParserConfigurationException {

	setup(uri);
    }

    public DialogSpaceBean(IDialogSpace space) {
	setup(space);
    }

    public void setup(String uri)
	throws IOException,
	       ClassNotFoundException,
	       SAXException,
	       ParserConfigurationException {

	_setupFactory();
	space_ = new SimpleDialogSpace(uri);
    }

    public void setup(IDialogSpace space) {
	space_ = space;
    }

    private void _setupFactory() {
	if (!(DialogFactory.getFactory() instanceof EvalDialogFactory)) {
	    DialogFactory.setFactory(new EvalDialogFactory());
	}
    }

    public final IDialogSpace getDialogSpace() {
	return (space_);
    }

    public final String getId() {
	return (space_.getId());
    }

    // slot
    public final Document getSlotDocument(String name)
	throws ParserConfigurationException {

	return (space_.getSlot(name).getDocument());
    }

    public final Document[] getSlotDocuments(String name)
	throws ParserConfigurationException {

	return (space_.getSlot(name).getDocuments());
    }

    public final void setSlotDocument(String name, Document doc) {
	space_.getSlot(name).setDocument(doc);
    }

    public final void setSlotDocument(String name, Document doc, Class type) {
	space_.getSlot(name).setDocument(doc, type);
    }

    public final void setSlotDocuments(String name, Document[] docs) {
	space_.getSlot(name).setDocuments(docs);
    }

    public final void setSlotDocuments(
	String name,
	Document[] docs,
	Class type
    ) {
	space_.getSlot(name).setDocuments(docs, type);
    }

    public final Object getSlotRObject(String name) {
	return (space_.getSlot(name).getRObject());
    }

    public final Object[] getSlotRObjects(String name) {
	return (space_.getSlot(name).getRObjects());
    }

    public final void setSlotRObject(String name, Object object) {
	space_.getSlot(name).setRObject(object);
    }

    public final void setSlotRObjects(String name, Object[] objects) {
	space_.getSlot(name).setRObjects(objects);
    }

    public final Object getSlotTabular(String name) {
	return (space_.getSlot(name).getTabular());
    }

    public final void setSlotTabular(String name, ITabular tabular) {
	space_.getSlot(name).setTabular(tabular);
    }

    // command
    public final Object executeCommand(String name) {
	IDialogCommand command = space_.getCommand(name);
	return (command.execute());
    }

    // management
    public final void open() throws IOException {
	space_.open();
    }

    public final void close() throws IOException {
	space_.close();
    }

    public final void flush() throws IOException {
	space_.flush();
    }

    public final void setPathResolver(IPathResolver resolver) {
	space_.setPathResolver(resolver);
    }
}
