package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * AbstractRelaxNgFactory is generated by Relaxer based on relaxNg.rxm.
 *
 * @version relaxNg.rxm 1.0 (Mon Aug 19 21:37:43 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public abstract class AbstractRelaxNgFactory implements IRelaxNgFactory {
    protected static org.xml.sax.ErrorHandler errorHandler;

    /**
     * Sets a error handler to handle parsing error.
     *
     * @param handler
     */
    public void setErrorHandler(org.xml.sax.ErrorHandler handler) {
        errorHandler = handler;
    }

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(File file) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(file, errorHandler));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(String uri) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(uri, errorHandler));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(URL url) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(url, errorHandler));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(in, errorHandler));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(is, errorHandler));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(reader, errorHandler));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Document doc) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(doc.getDocumentElement());
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Element element) throws IOException, SAXException, ParserConfigurationException {
        if (RNGrammar.isMatch(element)) {
            RNGrammar node = createRNGrammar();
            node.setup(element);
            return(node);
        } else if (RNDefine.isMatch(element)) {
            RNDefine node = createRNDefine();
            node.setup(element);
            return(node);
        } else if (RNAttribute.isMatch(element)) {
            RNAttribute node = createRNAttribute();
            node.setup(element);
            return(node);
        } else if (RNNsName.isMatch(element)) {
            RNNsName node = createRNNsName();
            node.setup(element);
            return(node);
        } else if (RNExcept.isMatch(element)) {
            RNExcept node = createRNExcept();
            node.setup(element);
            return(node);
        } else if (RNAnyName.isMatch(element)) {
            RNAnyName node = createRNAnyName();
            node.setup(element);
            return(node);
        } else if (RNName.isMatch(element)) {
            RNName node = createRNName();
            node.setup(element);
            return(node);
        } else if (RNNameChoice.isMatch(element)) {
            RNNameChoice node = createRNNameChoice();
            node.setup(element);
            return(node);
        } else if (RNData.isMatch(element)) {
            RNData node = createRNData();
            node.setup(element);
            return(node);
        } else if (RNParam.isMatch(element)) {
            RNParam node = createRNParam();
            node.setup(element);
            return(node);
        } else if (RNValue.isMatch(element)) {
            RNValue node = createRNValue();
            node.setup(element);
            return(node);
        } else if (RNRef.isMatch(element)) {
            RNRef node = createRNRef();
            node.setup(element);
            return(node);
        } else if (RNText.isMatch(element)) {
            RNText node = createRNText();
            node.setup(element);
            return(node);
        } else if (RNList.isMatch(element)) {
            RNList node = createRNList();
            node.setup(element);
            return(node);
        } else if (RNNotAllowed.isMatch(element)) {
            RNNotAllowed node = createRNNotAllowed();
            node.setup(element);
            return(node);
        } else if (RNEmpty.isMatch(element)) {
            RNEmpty node = createRNEmpty();
            node.setup(element);
            return(node);
        } else if (RNTextChoice.isMatch(element)) {
            RNTextChoice node = createRNTextChoice();
            node.setup(element);
            return(node);
        } else if (RNTextOptional.isMatch(element)) {
            RNTextOptional node = createRNTextOptional();
            node.setup(element);
            return(node);
        } else if (RNTextOneOrMore.isMatch(element)) {
            RNTextOneOrMore node = createRNTextOneOrMore();
            node.setup(element);
            return(node);
        } else if (RNTextZeroOrMore.isMatch(element)) {
            RNTextZeroOrMore node = createRNTextZeroOrMore();
            node.setup(element);
            return(node);
        } else if (RNElement.isMatch(element)) {
            RNElement node = createRNElement();
            node.setup(element);
            return(node);
        } else if (RNExternalRef.isMatch(element)) {
            RNExternalRef node = createRNExternalRef();
            node.setup(element);
            return(node);
        } else if (RNGroup.isMatch(element)) {
            RNGroup node = createRNGroup();
            node.setup(element);
            return(node);
        } else if (RNChoice.isMatch(element)) {
            RNChoice node = createRNChoice();
            node.setup(element);
            return(node);
        } else if (RNInterleave.isMatch(element)) {
            RNInterleave node = createRNInterleave();
            node.setup(element);
            return(node);
        } else if (RNMixed.isMatch(element)) {
            RNMixed node = createRNMixed();
            node.setup(element);
            return(node);
        } else if (RNOptional.isMatch(element)) {
            RNOptional node = createRNOptional();
            node.setup(element);
            return(node);
        } else if (RNZeroOrMore.isMatch(element)) {
            RNZeroOrMore node = createRNZeroOrMore();
            node.setup(element);
            return(node);
        } else if (RNOneOrMore.isMatch(element)) {
            RNOneOrMore node = createRNOneOrMore();
            node.setup(element);
            return(node);
        } else if (RNStart.isMatch(element)) {
            RNStart node = createRNStart();
            node.setup(element);
            return(node);
        } else if (RNInclude.isMatch(element)) {
            RNInclude node = createRNInclude();
            node.setup(element);
            return(node);
        } else if (RNDiv.isMatch(element)) {
            RNDiv node = createRNDiv();
            node.setup(element);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>RNGrammar</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(File file) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(File file) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(File file) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(File file) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(File file) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(File file) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(File file) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(File file) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(File file) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(File file) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(File file) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(File file) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(File file) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(File file) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(File file) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(File file) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(File file) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(File file) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(File file) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(File file) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(File file) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(File file) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(File file) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(File file) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(file, errorHandler));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(uri, errorHandler));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(url, errorHandler));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(in, errorHandler));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(is, errorHandler));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(reader, errorHandler));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Document doc) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(doc);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNDefine
     */
    public RNDefine createRNDefine(Document doc) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(doc);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Document doc) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(doc);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNsName
     */
    public RNNsName createRNNsName(Document doc) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(doc);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNExcept
     */
    public RNExcept createRNExcept(Document doc) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(doc);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Document doc) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(doc);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNName
     */
    public RNName createRNName(Document doc) {
        RNName rNName_ = createRNName();
        rNName_.setup(doc);
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Document doc) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(doc);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNData
     */
    public RNData createRNData(Document doc) {
        RNData rNData_ = createRNData();
        rNData_.setup(doc);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNParam
     */
    public RNParam createRNParam(Document doc) {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(doc);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNValue
     */
    public RNValue createRNValue(Document doc) {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(doc);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNRef
     */
    public RNRef createRNRef(Document doc) {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(doc);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNText
     */
    public RNText createRNText(Document doc) {
        RNText rNText_ = createRNText();
        rNText_.setup(doc);
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNList
     */
    public RNList createRNList(Document doc) {
        RNList rNList_ = createRNList();
        rNList_.setup(doc);
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Document doc) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(doc);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Document doc) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(doc);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Document doc) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(doc);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Document doc) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(doc);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Document doc) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(doc);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Document doc) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(doc);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNElement
     */
    public RNElement createRNElement(Document doc) {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(doc);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Document doc) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(doc);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNGroup
     */
    public RNGroup createRNGroup(Document doc) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(doc);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNChoice
     */
    public RNChoice createRNChoice(Document doc) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(doc);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Document doc) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(doc);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNMixed
     */
    public RNMixed createRNMixed(Document doc) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(doc);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNOptional
     */
    public RNOptional createRNOptional(Document doc) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(doc);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Document doc) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(doc);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Document doc) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(doc);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNStart
     */
    public RNStart createRNStart(Document doc) {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(doc);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNInclude
     */
    public RNInclude createRNInclude(Document doc) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(doc);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNDiv
     */
    public RNDiv createRNDiv(Document doc) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(doc);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Element element) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(element);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNDefine
     */
    public RNDefine createRNDefine(Element element) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(element);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Element element) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(element);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNsName
     */
    public RNNsName createRNNsName(Element element) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(element);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNExcept
     */
    public RNExcept createRNExcept(Element element) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(element);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Element element) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(element);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNName
     */
    public RNName createRNName(Element element) {
        RNName rNName_ = createRNName();
        rNName_.setup(element);
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Element element) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(element);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNData
     */
    public RNData createRNData(Element element) {
        RNData rNData_ = createRNData();
        rNData_.setup(element);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNParam
     */
    public RNParam createRNParam(Element element) {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(element);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNValue
     */
    public RNValue createRNValue(Element element) {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(element);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNRef
     */
    public RNRef createRNRef(Element element) {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(element);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNText
     */
    public RNText createRNText(Element element) {
        RNText rNText_ = createRNText();
        rNText_.setup(element);
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNList
     */
    public RNList createRNList(Element element) {
        RNList rNList_ = createRNList();
        rNList_.setup(element);
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Element element) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(element);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Element element) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(element);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Element element) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(element);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Element element) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(element);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Element element) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(element);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Element element) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(element);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNElement
     */
    public RNElement createRNElement(Element element) {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(element);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Element element) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(element);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNGroup
     */
    public RNGroup createRNGroup(Element element) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(element);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNChoice
     */
    public RNChoice createRNChoice(Element element) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(element);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Element element) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(element);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNMixed
     */
    public RNMixed createRNMixed(Element element) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(element);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNOptional
     */
    public RNOptional createRNOptional(Element element) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(element);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Element element) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(element);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Element element) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(element);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNStart
     */
    public RNStart createRNStart(Element element) {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(element);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNInclude
     */
    public RNInclude createRNInclude(Element element) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(element);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNDiv
     */
    public RNDiv createRNDiv(Element element) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(element);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(RStack stack) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(stack);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNDefine
     */
    public RNDefine createRNDefine(RStack stack) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(stack);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(RStack stack) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(stack);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNsName
     */
    public RNNsName createRNNsName(RStack stack) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(stack);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNExcept
     */
    public RNExcept createRNExcept(RStack stack) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(stack);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(RStack stack) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(stack);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNName
     */
    public RNName createRNName(RStack stack) {
        RNName rNName_ = createRNName();
        rNName_.setup(stack);
        return (rNName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(RStack stack) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(stack);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNData</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNData
     */
    public RNData createRNData(RStack stack) {
        RNData rNData_ = createRNData();
        rNData_.setup(stack);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNParam
     */
    public RNParam createRNParam(RStack stack) {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(stack);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNValue
     */
    public RNValue createRNValue(RStack stack) {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(stack);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNRef
     */
    public RNRef createRNRef(RStack stack) {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(stack);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNText
     */
    public RNText createRNText(RStack stack) {
        RNText rNText_ = createRNText();
        rNText_.setup(stack);
        return (rNText_);
    }

    /**
     * Creates a <code>RNList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNList
     */
    public RNList createRNList(RStack stack) {
        RNList rNList_ = createRNList();
        rNList_.setup(stack);
        return (rNList_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(RStack stack) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(stack);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(RStack stack) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(stack);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(RStack stack) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(stack);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(RStack stack) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(stack);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(RStack stack) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(stack);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(RStack stack) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(stack);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNElement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNElement
     */
    public RNElement createRNElement(RStack stack) {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(stack);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(RStack stack) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(stack);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNGroup
     */
    public RNGroup createRNGroup(RStack stack) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(stack);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNChoice
     */
    public RNChoice createRNChoice(RStack stack) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(stack);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(RStack stack) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(stack);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNMixed
     */
    public RNMixed createRNMixed(RStack stack) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(stack);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNOptional
     */
    public RNOptional createRNOptional(RStack stack) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(stack);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(RStack stack) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(stack);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(RStack stack) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(stack);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNStart</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNStart
     */
    public RNStart createRNStart(RStack stack) {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(stack);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNInclude
     */
    public RNInclude createRNInclude(RStack stack) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(stack);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNDiv
     */
    public RNDiv createRNDiv(RStack stack) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(stack);
        return (rNDiv_);
    }
}
