/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relaxng;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;
import jp.gr.java_conf.jaba2.xml.relax.expanded.*;

/**
 * URelaxNg
 *
 * @since   Jun. 13, 2001
 * @version Jul. 24, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class URelaxNg {
/*
    public static RNGGrammar buildGrammar(URL url) throws IOException {
	IProcessor processor = ProcessorFactory.getProcessor();
	return (buildGrammar(url, processor));
    }

    public static RNGGrammar buildGrammar(URL url, IProcessor processor)
	throws IOException {

	Document doc = processor.parseValidDocument(url);
	RNGrammar grammar = new RNGrammar(doc);
	return (new RNGGrammar(grammar));
    }
*/

    public static RNGGrammar buildGrammar(Element element, String baseURI) {
	String localName = element.getLocalName();
	if (localName.equals("grammar")) {
	    RNGrammar grammar = new RNGrammar(element);
	    return (new RNGGrammar(grammar, baseURI));
	} else if (localName.equals("element")) {
	    RNElement rElement = new RNElement(element);
	    return (new RNGGrammar(rElement, baseURI));
	} else {
	    throw (new InternalError());
	}
    }

/*
    public static ERelax buildEModel(URL url) throws IOException {
	IProcessor processor = ProcessorFactory.getProcessor();
	return (buildEModel(url, processor));
    }

    public static ERelax buildEModel(URL url, IProcessor processor)
	throws IOException {

	Document doc = processor.parseValidDocument(url);
	RNGrammar grammar = new RNGrammar(doc);
	CRelax crelax = UCRelax.buildModel(grammar);
	ERelax erelax = UERule.buildModel(crelax);
	return (erelax);
    }
*/
}
