/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.UElement;
import jp.gr.java_conf.jaba2.xml.datatype.*;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * RSimpleType
 *
 * @since   Feb. 22, 2001
 * @version Mar. 10, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RSimpleType extends RNode {
    private String name_;
    private String baseName_;
    private Element restriction_;
    private String listItemType_;

    public RSimpleType(Element element) {
	super(element);
	name_ = UString.checkNull(element.getAttribute("name"));
	_setupDatatype(element);
	listItemType_ = _getValue(element, "list", "itemType");
	if (baseName_ == null && listItemType_ == null) {
	    throw (new RSyntaxErrorException(
		"Invalid simpleType \"" + name_ + "\""
	    ));
	}
    }

    public final String getName() {
	return (name_);
    }

    public final String getBaseName() {
	return (baseName_);
    }

    public final Element getRestriction() {
	return (restriction_);
    }

    public final String getListItemType() {
	return (listItemType_);
    }

    private void _setupDatatype(Element element) {
	restriction_ = UElement.getOnlyElement(element, "restriction");
	if (restriction_ != null) {
	    baseName_ = UString.checkNull(restriction_.getAttribute("base"));
	}
    }

    private String _getValue(Element element, String eName, String aName) {
	return (
	    UElement.getAttributeOfOnlyElementAsString(element, eName, aName)
	);
    }
}
