/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.xml.relax.RELAXEntityResolver;

/**
 * RModule
 *
 * @since   Dec. 18, 1999
 * @version May. 28, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RModule {
    protected String fileURI_;
    protected String baseURI_;
    protected String moduleVersion_;
    protected String relaxCoreVersion_;
    protected String targetNamespace_;
    protected List exportLabels_ = new ArrayList();
    protected List exportRoles_ = new ArrayList();
    protected List importLabels_ = new ArrayList();
    protected List importRoles_ = new ArrayList();
    protected List contentRules_ = new ArrayList();
    protected List elementRules_ = new ArrayList();
    protected List tagPatterns_ = new ArrayList();
    protected List attListPatterns_ = new ArrayList();
    protected List simpleTypes_ = new ArrayList();

    public RModule(Element element, String baseURI) {
	setBaseURI(baseURI);
	_buildModule(element, baseURI);
    }

    protected void _buildModule(
	Element element,
	String baseURI
    ) {
	SmartElement sm = new SmartElement(element);
	NodeList nodes;
	int size;
	_buildModuleContents(element, baseURI);
	setModuleVersion(sm.getAttributeAsCDATA("moduleVersion"));
	setRelaxCoreVersion(sm.getAttributeAsCDATA("relaxCoreVersion"));
	setTargetNamespace(sm.getAttributeAsCDATA("targetNamespace"));
    }

    private void _buildModuleContents(
	Element element,
	String baseURI
    ) {
	Element[] elements = UElement.getElements(element);
	for (int i = 0;i < elements.length;i++) {
	    Element child = elements[i];
	    String localName = child.getLocalName();
	    if ("interface".equals(localName)) {
		_buildInterfaceContents(child);
	    } else if ("hedgeRule".equals(localName)) {
		RContentRule rule = new RContentRule(child);
		addContentRule(rule);
	    } else if ("elementRule".equals(localName)) {
		RElementRule rule = new RElementRule(child);
		addElementRule(rule);
	    } else if ("tag".equals(localName)) {
		RTagPattern rule = new RTagPattern(child);
		addTagPattern(rule);
	    } else if ("attPool".equals(localName)) {
		RAttListPattern rule = new RAttListPattern(child);
		addAttListPattern(rule);
	    } else if ("simpleType".equals(localName)) {
		RSimpleType type = new RSimpleType(child);
		addSimpleType(type);
	    } else if ("include".equals(localName)) {
		URL url = UElement.getAttributeAsURLByFileOrURLNameWithXMLBase(
		    child,
		    "moduleLocation",
		    baseURI
		);
		IProcessor processor = ProcessorFactory.getProcessor();
		processor.setEntityResolver(new RELAXEntityResolver());
		try {
		    Document doc = processor.parseValidDocument(url);
		    _buildModule(
			doc.getDocumentElement(),
			UURL.getBaseURI(url)
		    );
		} catch (IOException e) {
		    throw (new RSyntaxErrorException(
			"Can not include " + url
		    ));
		}
	    } else if ("div".equals(localName)) {
		_buildModuleContents(child, baseURI);
	    } else if ("annotation".equals(localName)) {
		// do nothing
	    } else {
		// do nothing
//		throw (new RSyntaxErrorException(
//		    "Unknown keyword " + localName
//		));
	    }
	}
    }

    private void _buildInterfaceContents(
	Element element
    ) {
	NodeList nodes = element.getElementsByTagName("export");
	int size = nodes.getLength();
	for (int i = 0;i < size;i++) {
	    Element child = (Element)nodes.item(i);
	    String label = UString.checkNull(child.getAttribute("label"));
	    String role = UString.checkNull(child.getAttribute("role"));
	    if (label != null) {
		addExportLabel(label);
	    } else if (role != null) {
		addExportRole(role);
	    } else {
		throw (new RSyntaxErrorException("Unknown export"));
	    }
	}
	nodes = element.getElementsByTagName("hedgeExport");
	size = nodes.getLength();
	for (int i = 0;i < size;i++) {
	    Element child = (Element)nodes.item(i);
	    String label = UString.checkNull(child.getAttribute("label"));
	    if (label != null) {
		addExportLabel(label);
	    } else {
		throw (new RSyntaxErrorException("Unknown export"));
	    }
	}
	nodes = element.getElementsByTagName("import");
	size = nodes.getLength();
	for (int i = 0;i < size;i++) {
	    Element child = (Element)nodes.item(i);
	    String label = UString.checkNull(child.getAttribute("label"));
	    String role = UString.checkNull(child.getAttribute("role"));
	    if (label != null) {
		addImportLabel(label);
	    } else if (role != null) {
		addImportRole(role);
	    } else {
		throw (new RSyntaxErrorException("Unknown import"));
	    }
	}
    }

    public void setFileURI(String uri) {
	fileURI_ = uri;
    }

    public void setBaseURI(String uri) {
	baseURI_ = uri;
    }

    public void setModuleVersion(String version) {
	moduleVersion_ = version;
    }

    public void setRelaxCoreVersion(String version) {
	relaxCoreVersion_ = version;
    }

    public void setTargetNamespace(String ns) {
	if (ns != null) {
	    targetNamespace_ = ns;
	} else {
	    targetNamespace_ = "";
	}
    }

    public void addExports(String[] labels) {
	for (int i = 0;i < labels.length;i++) {
	    addExportLabel(labels[i]);
	}
    }

    public void addExportLabel(String label) {
	exportLabels_.add(label);
    }

    public void addExportRole(String role) {
	exportRoles_.add(role);
    }

    public void addImportLabel(String label) {
	importLabels_.add(label);
    }

    public void addImportRole(String role) {
	importRoles_.add(role);
    }

    public void addContentRule(RContentRule rule) {
	contentRules_.add(rule);
    }

    public void addElementRule(RElementRule rule) {
	elementRules_.add(rule);
    }

    public void addTagPattern(RTagPattern pattern) {
	tagPatterns_.add(pattern);
    }

    public void addAttListPattern(RAttListPattern pattern) {
	attListPatterns_.add(pattern);
    }

    public void addSimpleType(RSimpleType type) {
	simpleTypes_.add(type);
    }

    public String getFileURI() {
	return (fileURI_);
    }

    public String getBaseURI() {
	return (baseURI_);
    }

    public String getModuleVersion() {
	return (moduleVersion_);
    }

    public String getRelaxCoreVersion() {
	return (relaxCoreVersion_);
    }

    public String getTargetNamespace() {
	return (targetNamespace_);
    }

    public String[] getExportLabels() {
	String[] exportLabels = new String[exportLabels_.size()];
	return ((String[])exportLabels_.toArray(exportLabels));
    }

    public String[] getExportRoles() {
	String[] exportRoles = new String[exportRoles_.size()];
	return ((String[])exportRoles_.toArray(exportRoles));
    }

    public String[] getImportLabels() {
	String[] imports = new String[importLabels_.size()];
	return ((String[])importLabels_.toArray(imports));
    }

    public String[] getImportRoles() {
	String[] imports = new String[importRoles_.size()];
	return ((String[])importRoles_.toArray(imports));
    }

    public RContentRule[] getContentRules() {
	RContentRule[] rules = new RContentRule[contentRules_.size()];
	return ((RContentRule[])contentRules_.toArray(rules));
    }

    public RElementRule[] getElementRules() {
	RElementRule[] rules = new RElementRule[elementRules_.size()];
	return ((RElementRule[])elementRules_.toArray(rules));
    }

    public RTagPattern[] getTagPatterns() {
	RTagPattern[] rules = new RTagPattern[tagPatterns_.size()];
	return ((RTagPattern[])tagPatterns_.toArray(rules));
    }

    public RAttListPattern[] getAttListPatterns() {
	RAttListPattern[] rules
	    = new RAttListPattern[attListPatterns_.size()];
	return ((RAttListPattern[])attListPatterns_.toArray(rules));
    }

    public RSimpleType[] getSimpleTypes() {
	RSimpleType[] types = new RSimpleType[simpleTypes_.size()];
	return ((RSimpleType[])simpleTypes_.toArray(types));
    }
}
