/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.Element;
import jp.gr.java_conf.jaba2.util.PropertyList;
import jp.gr.java_conf.jaba2.xml.pdom.PElement;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * ENode
 *
 * @since   Jan. 21, 2000
 * @version Jul. 12, 2002
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class ENode extends PElement {
    private EModule module_;
    private boolean isLeaf_ = true;
    private boolean isImmutable_ = false;
    private PropertyList properties_ = new PropertyList();
    private List noneElementNodes_ = new ArrayList(); // XXX : moveMethod?
    private List noneElementSlots_ = new ArrayList(); // XXX : moveMethod?
    private List noneAttributeSlots_ = new ArrayList(); // XXX : moveMethod?
    private EAppinfo appinfo_;
    private ERuleNode hometown_;
    private Element base_;
    private boolean isNone_ = false;
    private boolean lockWrite_ = false;
    private int lockRead_ = 0;

    public ENode() {
	super("enode");
    }

    protected ENode(String name) {
	super(name);
    }

    protected ENode(ENode node) {
	super(node.getTagName(), (PElement)node.getParentNode());
	module_ = node.module_;
	isLeaf_ = node.isLeaf_;
//	isImmutable_ = node.isImmutable_;
	properties_ = new PropertyList(node.properties_);
	// XXX : anothor stuff
	hometown_ = node.hometown_;
	base_ = node.base_;
	isNone_ = node.isNone_;
    }

    public final void setModule(EModule module) {
	module_ = module;
    }

    public final EModule getModule() {
	if (module_ != null) {
	    return (module_);
	}
	return (getParent().getModule());
    }

    public final boolean isLeaf() {
	return (isLeaf_);
    }

    public final boolean isImmutable() {
	return (isImmutable_);
    }

    public final void setImmutable(boolean immutable) {
	isImmutable_ = immutable;
    }

    public final int getSize() {
	return (children_.size());
    }

    public final ENode getParent() {
	return ((ENode)getParentNode());
    }

    public final ENode[] getChildren() {
	ENode[] children = new ENode[size()];
	return ((ENode[])toArray(children));
    }

    public final void addChild(ENode child) {
	if (isImmutable_ || child.isImmutable_) {
	    throw (new InternalError("add " + child + " to " + this));
	}
	if (child instanceof ETempNode) {
	    addChildren(child);
	} else {
	    appendChild(child);
	}
	if (!(child instanceof ESlotNode)) {
	    isLeaf_ = false;
	}
    }

    public final void addChildren(ENode children) {
	if (isImmutable_) {
	    throw (new InternalError());
	}
	addChildren(children.getChildren());
    }

    public final void addChildren(List children) {
	if (isImmutable_) {
	    throw (new InternalError());
	}
	int size = children.size();
	for (int i = 0;i < size;i++) {
	    addChild((ENode)children.get(i));
	}
    }

    public final void addChildren(ENode[] children) {
	if (isImmutable_) {
	    throw (new InternalError());
	}
	for (int i = 0;i < children.length;i++) {
	    addChild(children[i]);
	}
    }

    public final void addChildrenDeep(ENode node) {
	addChildrenDeep(node.getChildren());
    }

    public final void addChildrenDeep(ENode[] children) {
	if (isImmutable_) {
	    throw (new InternalError());
	}
	for (int i = 0;i < children.length;i++) {
	    addChild(_deepCopy(children[i]));
	}
    }

    private ENode _deepCopy(ENode node) {
	if (node instanceof EElementSlot) {
	    return (new EElementSlot((EElementSlot)node));
	} else if (node instanceof EAttributeSlot) {
	    return (new EAttributeSlot((EAttributeSlot)node));
	} else if (node instanceof EElementRefNode) {
	    return (new EElementRefNode((EElementRefNode)node));
	} else if (node instanceof EContentRefNode) {
	    return (new EContentRefNode((EContentRefNode)node));
	} else if (node instanceof EChoiceNode) {
	    return (new EChoiceNode((EChoiceNode)node)); // XXX : modify
	} else if (node instanceof ENoneNode) {
	    return (new ENoneNode());
	} else if (node instanceof EExternalRefNode) {
	    return (new EExternalRefNode((EExternalRefNode)node));
	} else if (node instanceof EExternalContentRefNode) {
	    return (
		new EExternalContentRefNode((EExternalContentRefNode)node)
	    );
	} else if (node instanceof EAnyOtherAttributeNode) {
	    return (new EAnyOtherAttributeNode((EAnyOtherAttributeNode)node));
	} else if (node instanceof EAnyOtherElementNode) {
	    return (new EAnyOtherElementNode((EAnyOtherElementNode)node));
	} else if (node instanceof EDataSlot) {
	    return (new EDataSlot((EDataSlot)node));
	} else if (node instanceof EValueSlot) {
	    return (new EValueSlot((EValueSlot)node));
	} else {
	    throw (new InternalError());
	}
    }

    public final void setProperty(String key, Object value) {
	properties_.put(key, value);
    }

    public final Object getProperty(String key) {
	return (properties_.get(key));
    }

    public final void addNoneElementNode(EElementNode node) {
	if (isImmutable_) {
	    throw (new InternalError());
	}
	noneElementNodes_.add(node);
    }

    public final void addNoneElementSlot(EElementSlot slot) {
	if (isImmutable_) {
	    throw (new InternalError());
	}
	noneElementSlots_.add(slot);
    }

    public final void addNoneAttributeSlot(EAttributeSlot slot) {
	noneAttributeSlots_.add(slot);
    }

    public final EElementNode[] getNoneElementNodes() {
	EElementNode[] nodes = new EElementNode[noneElementNodes_.size()];
	return ((EElementNode[])noneElementNodes_.toArray(nodes));
    }

    public final EElementSlot[] getNoneElementSlots() {
	EElementSlot[] slots = new EElementSlot[noneElementSlots_.size()];
	return ((EElementSlot[])noneElementSlots_.toArray(slots));
    }

    public final EAttributeSlot[] getNoneAttributeSlots() {
	EAttributeSlot[] slots
	    = new EAttributeSlot[noneAttributeSlots_.size()];
	return ((EAttributeSlot[])noneAttributeSlots_.toArray(slots));
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }

    public void traverse(IEVisitor visitor) {
	_traverse(visitor);
    }

    protected void _traverse(IEVisitor visitor) {
	if (enter(visitor)) {
	    ENode[] children = getChildren();
	    for (int i = 0;i < children.length;i++) {
		children[i]._traverse(visitor);
	    }
	    leave(visitor);
	}
    }

    public final void setAppinfo(EAppinfo appinfo) {
	appinfo_ = appinfo;
    }

    public final EAppinfo getAppinfo() {
	return (appinfo_);
    }

    public final void setHometown(ERuleNode hometown) {
	if (hometown_ != null) {
	    throw (new InternalError());
	}
	hometown_ = hometown;
    }

    public final ERuleNode getHometown() {
	return (hometown_);
    }

    public final void setBase(Element base) {
	if (base_ != null) {
	    throw (new InternalError());
	}
	base_ = base;
    }

    public final Element getBase() {
	return (base_);
    }

    public void setNone(boolean isNone) {
	isNone_ = isNone;
    }

    public boolean isNone() {
	return (isNone_);
/*
	ENode[] children = getChildren();
	for (int i = 0;i < children.length;i++) {
	    if (children[i] instanceof ENoneNode) {
		return (true);
	    }
	}
	return (false);
*/
    }

    public synchronized void lockWrite() throws InterruptedException {
	while (lockWrite_ || lockRead_ > 0) {
//System.out.println("lockWrite - wait: " + Thread.currentThread());
//System.out.println(lockWrite_ + ":" + lockRead_);
	    wait();
	}
	lockWrite_ = true;
//System.out.println("lockWrite - lock: " + Thread.currentThread());
    }

    public synchronized void unlockWrite() throws InterruptedException {
	if (!lockWrite_ || lockRead_ > 0) {
	    throw (new InternalError());
	}
	lockWrite_ = false;
	notifyAll();
//System.out.println("lockWrite - unlock: " + Thread.currentThread());
    }

    public synchronized boolean isLockWrite() {
	return (lockWrite_ || lockRead_ > 0);
    }

    public synchronized void lockRead() throws InterruptedException {
	while (lockWrite_) {
//System.out.println("lockRead - wait: " + Thread.currentThread());
	    wait();
	}
	lockRead_++;
//System.out.println("lockRead - lock: " + Thread.currentThread());
    }

    public synchronized void unlockRead() throws InterruptedException {
	if (lockWrite_ || lockRead_ <= 0) {
	    throw (new InternalError());
	}
	lockRead_--;
	if (lockRead_ == 0) {
	    notifyAll();
	} else if (lockRead_ < 0) {
	    throw (new InternalError());
	}
//System.out.println("lockRead - unlock: " + Thread.currentThread());
    }

    public synchronized boolean isLockRead() {
	return (lockWrite_);
    }
}
