/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EMixedNode
 *
 * @since   Mar.  1, 2000
 * @version Jul. 13, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class EMixedNode extends ENode implements IEOccurs {
    private int occurs_;	// for hint
    private EMixedNode origin_;

    public EMixedNode() {
	super("mixed");
	setOccurs(OCCURS_ONE);
	origin_ = this;
    }

    public EMixedNode(EMixedNode mixed) {
	super(mixed);
	setOccurs(mixed.occurs_);
	origin_ = mixed.origin_;
	addChildrenDeep(mixed);
    }	

    public EMixedNode getOrigin() {
	return (origin_);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
	setAttribute("occurs", UERule.getOccursSymbol(occurs_));
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
