/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * DDouble
 *
 * @since   Feb. 23, 2000
 * @version Dec. 13, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DDouble extends Datatype {
    // facets
    private Double maxInclusive_;
    private Double maxExclusive_;
    private Double minInclusive_;
    private Double minExclusive_;
    private Double[] enumeration_;

    public DDouble() {
    }

    public DDouble(Element element) {
	setup(element);
    }

    public void setup(Element element) {
	SmartElement sm = new SmartElement(element);
	maxInclusive_
	    = sm.getAttributeOfOnlyElementAsDouble("maxInclusive", "value");
	maxExclusive_
	    = sm.getAttributeOfOnlyElementAsDouble("maxExclusive", "value");
	minInclusive_
	    = sm.getAttributeOfOnlyElementAsDouble("minInclusive", "value");
	minExclusive_
	    = sm.getAttributeOfOnlyElementAsDouble("minExclusive", "value");
	// XXX : enumeration_
    }

    public String getName() {
	return ("double");
    }

    public final Double getMaxInclusive() {
	return (maxInclusive_);
    }

    public final Double getMaxExclusive() {
	return (maxExclusive_);
    }

    public final Double getMinInclusive() {
	return (minInclusive_);
    }

    public final Double getMinExclusive() {
	return (minExclusive_);
    }

    public final Double[] getEnumeration() {
	return (enumeration_);
    }

    public Object makeObject(String cdata) {
	return (Double.valueOf(cdata));
    }
}
