/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package jp.gr.java_conf.jaba2.text.generator;

import org.apache.oro.text.regex.*;

/**
 * SimpleGenerator
 *
 * @since   Feb.  5, 1998
 * @version Aug. 30, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class SimpleGenerator implements Generator {
    public SimpleGenerator() {
	model_ = null;
    }

    public SimpleGenerator(GeneratorModel model) {
	model_ = model;
    }

    public void setModel(GeneratorModel model) {
	model_ = model;
    }

    // Generator
    public String generate() {
	String prototype = model_.getPrototype();
	String text = prototype;
	String[] tags = model_.getTags();
	for (int i = 0;i < tags.length;i++) {
	    String subst = model_.getSubstituteString(tags[i]);
	    if (subst != null) {
		text = _substitute(text, tags[i], subst);
	    }		
	}
	return (text);
    }

    protected String _substitute(String text, String regex, String subst) {
	String result = text;
	try {
	    PatternMatcher matcher = new Perl5Matcher();
	    PatternCompiler compiler = new Perl5Compiler();
	    Pattern pattern = compiler.compile(regex);
	    result = Util.substitute(
		matcher,
		pattern,
		new StringSubstitution(subst), // XXX : Perl5??
		text,
		Util.SUBSTITUTE_ALL
	    );
	} catch (MalformedPatternException e) {
	}
	return (result);
    }

    protected GeneratorModel model_;
}
