/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.packager;

import java.io.File;
import java.io.IOException;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.parcel.IParcel;
import jp.gr.java_conf.jaba2.parcel.IGadget;
import jp.gr.java_conf.jaba2.parcel.UParcel;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * AbstractDOMBusPackager
 *
 * @since   Aug. 25, 2000
 * @version Aug. 25, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractDOMBusPackager extends AbstractDOMBusComponent
    implements IDOMBusPackager {

    public Object fire(DOMBusSignal signal) {
	Object content = signal.getContent();
	if (content instanceof IParcel) {
	    _packByParcel((IParcel)content);
	} else {
	    _packByProperty(signal);
	}
	return (null);
    }

    private void _packByParcel(IParcel parcel) {
	pack(parcel);
    }

    private void _packByProperty(DOMBusSignal signal) {
	String urlName = (String)signal.getProperty("url");
	if (urlName == null) {
	    urlName = "output";
	}
	String encoding = (String)signal.getProperty("encoding");
	if (encoding == null) {
	    encoding = "UTF-8";
	}
	String backup = (String)signal.getProperty("backup");
	IParcel parcel = UParcel.makeParcel(
	    urlName,
	    signal.getContent(),
	    encoding
	);
	parcel.setProperty("backup", backup);
	pack(parcel);
    }

    public void pack(IParcel parcel) {
	IGadget[] gadgets = parcel.getGadgets();
	for (int i = 0;i < gadgets.length;i++) {
	    IGadget gadget = gadgets[i];
	    _pack(gadget);
	}
    }

    protected void _pack(IGadget gadget) {
	throw (new UnsupportedOperationException());
    }
}
