package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CComponentSet</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="componentSet">
 *   <ref label="slot" occurs="*"/>
 * </elementRule>
 * 
 * <tag name="componentSet"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="componentSet"&gt;
 *   &lt;ref label="slot" occurs="*"/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="componentSet"/&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:15 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CComponentSet implements java.io.Serializable {
    // List<CSlot>
    private java.util.List slot = new java.util.ArrayList();

    /**
     * Creates a <code>CComponentSet</code>.
     *
     */
    public CComponentSet() {
    }

    /**
     * Creates a <code>CComponentSet</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CComponentSet(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CComponentSet</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CComponentSet(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CComponentSet</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CComponentSet(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CComponentSet</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CComponentSet</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CComponentSet</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        slot.clear();
        while (!stack.isEmptyElement()) {
            if (CSlot.isMatch(stack)) {
                addSlot(factory.createCSlot(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("componentSet");
        int size;
        size = slot.size();
        for (int i = 0;i < size;i++) {
            CSlot value = (CSlot)this.slot.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the CSlot property <b>slot</b>.
     *
     * @return CSlot[]
     */
    public final CSlot[] getSlot() {
        CSlot[] array = new CSlot[slot.size()];
        return ((CSlot[])slot.toArray(array));
    }

    /**
     * Sets the CSlot property <b>slot</b>.
     *
     * @param slot
     */
    public final void setSlot(CSlot[] slot) {
        this.slot.clear();
        this.slot.addAll(java.util.Arrays.asList(slot));
    }

    /**
     * Adds the CSlot property <b>slot</b>.
     *
     * @param slot
     */
    public final void addSlot(CSlot slot) {
        this.slot.add(slot);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CComponentSet</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"componentSet".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!CSlot.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CComponentSet</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CComponentSet</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
