/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.lwlayout;

import java.util.*;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import jp.gr.java_conf.jaba2.awt.*;

/**
 * AdapterLightWeightLayout
 *
 * @since   Jan.  5, 1999
 * @version Feb. 18, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class AdapterLightWeightLayout
    extends AbstractLightWeightLayoutManager {

    protected LayoutManager layout_;
    protected Container stub_ = new StubContainer();

    public AdapterLightWeightLayout(LayoutManager layout) {
	layout_ = layout;
	stub_.setLayout(layout_);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
	stub_.add(comp, constraints);
    }

    public void removeLayoutComponent(Component comp) {
	stub_.remove(comp);
    }

    public void layoutComponents(Rectangle bounds) {
//System.out.println("Adapter - layoutComponents : " + bounds);
	stub_.setBounds(bounds);
	layout_.layoutContainer(stub_);
	int size = stub_.getComponentCount();
	for (int i = 0;i < size;i++) {
	    Component comp = stub_.getComponent(i);
	    Point pos = comp.getLocation();
//System.out.println("Adapter - layoutComponents : (pos)  " + pos);
	    pos.x += bounds.x;
	    pos.y += bounds.y;
	    comp.setLocation(pos);
	}
    }

    public Dimension preferredLayoutSize() {
	return (layout_.preferredLayoutSize(stub_));
    }

    public Dimension minimumLayoutSize() {
	return (layout_.minimumLayoutSize(stub_));
    }

    class StubContainer extends NullContainer {
	protected List comps_ = new ArrayList();

	public void add(Component comp, Object constraints) {
	    comps_.add(comp);
	    LayoutManager layout = getLayout();
	    if (layout instanceof LayoutManager2) {
		((LayoutManager2)layout).addLayoutComponent(comp, constraints);
	    } else {
		layout.addLayoutComponent((String)constraints, comp);
	    }
	}

	public void remove(Component comp) {
	    comps_.remove(comp);
	    getLayout().removeLayoutComponent(comp);
	}

	public int getComponentCount() {
	    return (comps_.size());
	}

	public Component getComponent(int i) {
	    return ((Component)comps_.get(i));
	}

	public Component[] getComponents() {
	    Component[] comps = new Component[comps_.size()];
	    return ((Component[])comps_.toArray(comps));
	}
    }
}
