/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.Color;
import javax.swing.*;

/**
 * AbstractGraphObject
 *
 * @since   Dec.  8, 1998
 * @version Feb.  8, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractGraphObject extends JComponent
    implements GraphObject {

    protected GraphModel model_;
    protected boolean selected_ = false;
    protected boolean hilight_ = false;
    protected boolean hilightable_ = true;
    protected boolean selectable_ = true;
    protected boolean movable_ = true;
    protected boolean removable_ = true;
    protected String layoutName_ = null;
    protected Object constraints_ = null;

    protected AbstractGraphObject() {
    }

    protected AbstractGraphObject(GraphModel model) {
	model_ = model;
    }

    public void setModel(GraphModel model) {
	model_ = model;
    }

    public void setHilight(boolean hilight) {
	hilight_ = hilight;
    }

    public void setSelected(boolean selected) {
	selected_ = selected;
    }

    public void setHilightable(boolean hilightable) {
	hilightable_ = hilightable;
    }

    public void setSelectable(boolean selectable) {
	selectable_ = selectable;
    }

    public void setMovable(boolean movable) {
	movable_ = movable;
    }

    public void setRemovable(boolean removable) {
	removable_ = removable;
    }

    public void setLayoutName(String layoutName) {
	layoutName_ = layoutName;
    }

    public void setLayoutConstraints(Object layoutConstraints) {
	constraints_ = layoutConstraints;
    }

    public GraphModel getModel() {
	return (model_);
    }

    public boolean isHilight() {
	return (hilight_);
    }

    public boolean isSelected() {
	return (selected_);
    }

    public boolean isHilightable() {
	return (hilightable_);
    }

    public boolean isSelectable() {
	return (selectable_);
    }

    public boolean isMovable() {
	return (movable_);
    }

    public boolean isRemovable() {
	return (removable_);
    }

    public boolean isValidPosition(int x, int y) {
	return (true);
    }

    public boolean isAction() {
	return (false);
    }

    public Action[] getActions() {
	return (new Action[0]);
    }

    public String getLayoutName() {
	return (layoutName_);
    }

    public Object getLayoutConstraints() {
	return (constraints_);
    }
}
