package jp.gr.java_conf.jaba2.awt.explorer;

import java.util.Observable;
import javax.swing.AbstractListModel;
import javax.swing.tree.TreePath;

/**
 * AbstractShortcutListModel
 *
 * @since   May. 16, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractShortcutListModel
    extends AbstractListModel
    implements ShortcutListModel {

    protected ExplorerModel emodel_;
    protected TreePath current_ = null;

    public AbstractShortcutListModel(ExplorerModel emodel) {
	emodel_ = emodel;
    }

    // Observer
    public void update(Observable o, Object arg) {
	if (o instanceof ExplorerModel) {
	    TreePath path = (TreePath)arg;
	    if (path.equals(current_)) {
		return;
	    }
	    current_ = path;
	    notifySelection(path);
	}
    }

    // ShortcutListModel
    public void setSelection(TreePath path) {
	emodel_.setSelection(path);
    }

    // ShorcutListModel
    public void notifySelection(TreePath path) {
    }
}
