/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.plain;

import org.w3c.dom.Text;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.text.cui.*;
import jp.gr.java_conf.jaba2.xml.pdom.PText;

/**
 * TText
 *
 * @since   Oct.  8, 1999
 * @version Mar. 19, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TText extends PText implements TNode {
    public TText(String text) {
	super(text);
    }

    public boolean isVerticalGap() {
	return (false);
    }

    public void normalize() {
    }

    public String format() {
	return (getData());
    }

    public void format(StringBuffer buffer) {
	buffer.append(getData());
    }

    public void format(CPanel node) {
	CBox text = new CBox(getData());
	text.setNatural(true);
	node.append(text);
    }

    public int getTopGap() {
	return (0);
    }

    public int getBottomGap() {
	return (0);
    }
}
