/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.xml.relaxng.URelaxNg;
import jp.gr.java_conf.jaba2.xml.relaxng.RNGGrammar;

/**
 * URRelax
 *
 * @since   Dec. 18, 1999
 * @version Jun. 19, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class URRelax {
    public static RRelax buildModel(Document doc) {
	return (buildModel(doc, null));
    }

    public static RRelax buildModel(Document doc, String baseURI) {
	Element element = doc.getDocumentElement();
	RRelax relax = new RRelax();
	String namespaceURI = element.getNamespaceURI();
	String localName = element.getLocalName();
	if ("module".equals(localName)) {
	    RModule module = new RModule(element, baseURI);
	    relax.addModule(module);
	} else if ("grammar".equals(localName)) {
	    if (namespaceURI != null &&
		namespaceURI.startsWith("http://relaxng.org/")) {

		RNGGrammar grammar = URelaxNg.buildGrammar(element, baseURI);
		relax.addNgGrammar(grammar);
	    } else {
		RGrammar grammar = new RGrammar(element, baseURI);
		relax.setGrammar(grammar);
		RModule[] modules = grammar.getModules();
		for (int i = 0;i < modules.length;i++) {
		    relax.addModule(modules[i]);
		}
	    }
	} else {
	    throw (new UnsupportedOperationException());
	}
	return (relax);
    }

    public static RNode[] buildContents(Element element) {
	List list = new ArrayList();
	NodeList children = element.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = children.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		Element echild = (Element)child;
		String localname = echild.getLocalName();
		// rule
		if ("ref".equals(localname)) {
		    list.add(new RRef(echild));
		} else if ("hedgeRef".equals(localname)) {
		    list.add(new RRef(echild));
		} else if ("importedLabelRef".equals(localname)) {
		    list.add(new RImportedLabelRef(echild));
		} else if ("importedRoleRef".equals(localname)) {
		    list.add(new RRef(echild));
		} else if ("sequence".equals(localname)) {
		    list.add(new RSequence(echild));
		} else if ("choice".equals(localname)) {
		    list.add(new RChoice(echild));
		} else if ("mixed".equals(localname)) {
		    list.add(new RMixed(echild));
		} else if ("element".equals(localname)) {
		    list.add(new RElement(echild));
		} else if ("anyOtherElement".equals(localname)) {
		    list.add(new RAnyOtherElement(echild));
		} else if ("empty".equals(localname)) {
		    list.add(new REmpty(echild));
		} else if ("none".equals(localname)) {
		    list.add(new RNone(echild));
//		} else if ("datatypeRef".equals(localname)) {
//		    list.add(new RDatatypeRef(echild));
		// pattern
		} else if ("tag".equals(localname)) {
		    list.add(new RTagPattern(echild));
		} else if ("attribute".equals(localname)) {
		    list.add(new RAttribute(echild));
		} else if ("anyOtherAttribute".equals(localname)) {
		    list.add(new RAnyOtherAttribute(echild));
		} else if ("enumeration".equals(localname)) {
		    list.add(new REnumeration(echild));
		} else if ("literal".equals(localname)) {
		    list.add(new RLiteral(echild));
/*
		// simpleType
		} else if ("simpleType".equals(localname)) {
		    list.add(new RSimpleType(echild));
		// include
		} else if ("include".equals(localname)) {
		    list.add(new RInclude(echild));
*/
		} else {
		    // do nothing
//		    throw (new InternalError());
		}
	    }
	}
	RNode[] result = new RNode[list.size()];
	return ((RNode[])list.toArray(result));
    }

    // test driver
    public static void main(String[] args) throws Exception {
	java.net.URL url
	    = jp.gr.java_conf.jaba2.io.UURL.getURLFromFileOrURLName(args[0]);
	jp.gr.java_conf.jaba2.xml.IProcessor processor
	    = jp.gr.java_conf.jaba2.xml.ProcessorFactory.getProcessor();
	Document doc = processor.parseDocument(url);
	RRelax relax = buildModel(doc);
    }
}
