/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * RRef
 *
 * @since   Dec. 18, 1999
 * @version May.  7, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RRef extends RNode {
    private String label_;
    private String pattern_;
    private String occurs_;
    private String namespace_;

    public RRef(Element element) {
	super(element);
	label_ = UString.checkNull(element.getAttribute("label"));
	pattern_ = UString.checkNull(element.getAttribute("role"));
	if (pattern_ == null) {
	    pattern_ = UString.checkNull(element.getAttribute("pred"));
	}
	occurs_ = UString.checkNull(element.getAttribute("occurs"));
	namespace_ = _getAttribute(element, "namespace");
    }

    private String _getAttribute(Element element, String name) {
	Attr attr = element.getAttributeNode(name);
	if (attr == null) {
	    return (null);
	} else {
	    return (attr.getValue());
	}
    }

    public final String getLabel() {
	return (label_);
    }

    public final String getPattern() {
	return (pattern_);
    }

    public final String getOccurs() {
	return (occurs_);
    }

    public final String getNamespace() {
	return (namespace_);
    }
}
