/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EContentRefNode
 *
 * @since   Jan. 17, 2000
 * @version Dec. 15, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class EContentRefNode extends ENode implements IEOccurs {
    private EContentNode contentNode_;
    private int occurs_;

    public EContentRefNode(EContentNode ref) {
	this(ref, OCCURS_ONE);
    }

    public EContentRefNode(EContentNode ref, int occurs) {
	super("contentRef");
	contentNode_ = ref;
	occurs_ = occurs;
	setAttribute("href", "#content" + ref.getId());
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public EContentRefNode(EContentRefNode erNode) {
	this(erNode.getContentNode(), erNode.getOccurs());
    }

    public final EContentNode getContentNode() {
	return (contentNode_);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }

    public synchronized void lockWrite() throws InterruptedException {
	super.lockWrite();
	contentNode_.lockWrite();
    }

    public synchronized void unlockWrite() throws InterruptedException {
	contentNode_.unlockWrite();
	super.unlockWrite();
    }

    public synchronized boolean isLockWrite() {
	return (contentNode_.isLockWrite());
    }

    public synchronized void lockRead() throws InterruptedException {
	super.lockRead();
	contentNode_.lockRead();
    }

    public synchronized void unlockRead() throws InterruptedException {
	contentNode_.unlockRead();
	super.unlockRead();
    }

    public synchronized boolean isLockRead() {
	return (contentNode_.isLockRead());
    }
}
