/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import java.io.ByteArrayOutputStream;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * DBinary
 *
 * @since   Feb. 24, 2000
 * @version Feb. 29, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DBinary extends Datatype {
    // facets
    private Integer length_;
    private Integer minlength_;
    private Integer maxlength_;
    private String encoding_;

    public DBinary() {
    }

    public DBinary(Element element) {
	setup(element);
    }

    public void setup(Element element) {
	SmartElement sm = new SmartElement(element);
	length_
	    = sm.getAttributeOfOnlyElementAsInteger("length", "value");
	minlength_
	    = sm.getAttributeOfOnlyElementAsInteger("minlength", "value");
	maxlength_
	    = sm.getAttributeOfOnlyElementAsInteger("maxlength", "value");
	encoding_
	    = sm.getAttributeOfOnlyElementAsString("encoding", "value");
    }

    public String getName() {
	return ("binary");
    }

    public String makeCDATA(Object object) {
	String cdata = makeStringAsBASE64((byte[])object);
	return (cdata);
    }

    public Object makeObject(String cdata) {
	Object object = makeBytesByBASE64(cdata);
	return (object);
    }

    public static String makeStringAsBASE64(byte[] bytes) {
	StringBuffer buffer = new StringBuffer();
	int count = 0;
	for (int i = 0;i < bytes.length;i += 3) {
	    int data1 = (bytes[i] & 0xFC) >> 2;
	    int data2;
	    int data3;
	    int data4;
	    if (i + 1 >= bytes.length) {
		data2 = (bytes[i] & 0x03) << 4;
		data3 = -1;
		data4 = -1;
	    } else {
		data2 =
		    ((bytes[i] & 0x03) << 4) |
		    ((bytes[i + 1] & 0xF0) >> 4);
		if (i + 2 >= bytes.length) {
		    data3 = (bytes[i + 1] & 0x0F) << 2;
		    data4 = -1;
		} else {
		    data3 =
			((bytes[i + 1] & 0x0F) << 2) |
			((bytes[i + 2] & 0xC0) >> 6);
		    data4 = bytes[i + 2] & 0x3F;
		}
	    }
	    buffer.append(map__[data1]);
	    buffer.append(map__[data2]);
	    if (data3 == -1) {
		buffer.append("=");
	    } else {
		buffer.append(map__[data3]);
	    }
	    if (data4 == -1) {
		buffer.append("=");
	    } else {
		buffer.append(map__[data4]);
	    }
	    count += 4;
	    if (count >= 76) {
		buffer.append("\n");
		count = 0;
	    }
	}
	return (new String(buffer));
    }

    public static byte[] makeBytesByBASE64(String cdata) {
	ByteArrayOutputStream buffer = new ByteArrayOutputStream();
	int status = 0;
	int byteData = 0;
	int size = cdata.length();
	for (int i = 0;i < size;i++) {
	    int charData = cdata.charAt(i);
	    int newData = _calcData(charData);
	    if (charData == '=') {
		break;
	    }
	    if (newData != -1) {
		switch (status) {

		case 0:
		    byteData = newData << 2;
		    status = 1;
		    break;
		case 1:
		    byteData |= (newData & 0x30) >> 4;
		    buffer.write(byteData);
		    byteData = (newData & 0x0F) << 4;
		    status = 2;
		    break;
		case 2:
		    byteData |= (newData & 0x3C) >> 2;
		    buffer.write(byteData);
		    byteData = (newData & 0x03) << 6;
		    status = 3;
		    break;
		case 3:
		    byteData |= (newData);
		    buffer.write(byteData);
		    status = 0;
		    break;
		default:
		    throw (new InternalError());
		}
	    }
	}
	return (buffer.toByteArray());
    }

    private static int _calcData(int charData) {
	if ('A' <= charData && charData <= 'Z') {
	    return (charData - 'A');
	}
	if ('a' <= charData && charData <= 'z') {
	    return (charData - 'a' + 26);
	}
	if ('0' <= charData && charData <= '9') {
	    return (charData - '0' + 26 + 26);
	}
	if (charData == '+') {
	    return (78);
	}
	if (charData == '/') {
	    return (79);
	}
	return (-1);
    }

    private static char[] map__ = {
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
	'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
	'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
	'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
	'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
	'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
	'w', 'x', 'y', 'z', '0', '1', '2', '3',
	'4', '5', '6', '7', '8', '9', '+', '/'
    };
}
