package jp.gr.java_conf.jaba2.text.updater.ruleR;

import org.w3c.dom.*;

/**
 * <b>RuleSet</b> is generated by Relaxer based on rule.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="ruleSet">
 *   <tag/>
 *   <sequence>
 *     <ref label="rule" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="ruleSet"&gt;
 *   &lt;tag/&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="rule" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag/&gt;
 * </pre>
 *
 * @version rule.rlx (Thu Nov 09 13:17:42 JST 2000)
 * @author  Relaxer 0.11.1b (by ASAMI@Yokohama)
 */
public class RuleSet implements java.io.Serializable {
    // List<Rule>
    private java.util.List rule_ = new java.util.ArrayList();

    /**
     * Creates a <code>RuleSet</code>.
     *
     */
    public RuleSet() {
    }

    /**
     * Creates a <code>RuleSet</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RuleSet(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RuleSet</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RuleSet(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RuleSet</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RuleSet(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>RuleSet</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RuleSet</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RuleSet</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IRuleFactory factory = RuleFactory.getFactory();
        RStack stack = new RStack(element);
        rule_.clear();
        while (!stack.isEmptyElement()) {
            if (Rule.isMatch(stack)) {
                addRule(factory.createRule(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("ruleSet");
        int size;
        size = this.rule_.size();
        for (int i = 0;i < size;i++) {
            Rule value = (Rule)this.rule_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the Rule property <b>rule</b>.
     *
     * @return Rule[]
     */
    public final Rule[] getRule() {
        Rule[] array = new Rule[rule_.size()];
        return ((Rule[])rule_.toArray(array));
    }

    /**
     * Sets the Rule property <b>rule</b>.
     *
     * @param rule
     */
    public final void setRule(Rule[] rule) {
        this.rule_.clear();
        this.rule_.addAll(java.util.Arrays.asList(rule));
    }

    /**
     * Sets the Rule property <b>rule</b>.
     *
     * @param rule
     */
    public final void setRule(Rule rule) {
        this.rule_.clear();
        this.rule_.add(rule);
    }

    /**
     * Adds the Rule property <b>rule</b>.
     *
     * @param rule
     */
    public final void addRule(Rule rule) {
        this.rule_.add(rule);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RuleSet</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "ruleSet")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Rule.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RuleSet</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RuleSet</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
