/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.lang;

import java.util.*;

/**
 * LJClass
 *
 * @since   Jan. 17, 2000
 * @version Aug. 27, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class LJMethod implements IAccessMode {
    private String id_;
    private String name_;
    private int access_;
    private LJArgument[] arguments_;
    private LJType returnType_;
    private LJType[] exceptions_;
    private boolean final_;
    private boolean static_;
    private String implementation_;
    private String desc_;
    private HashMap properties_ = new HashMap();

    public LJMethod(
	String name,
	int access,
	LJType returnType
    ) {
	name_ = name;
	access_ = access;
	returnType_ = returnType;
	arguments_ = new LJArgument[0];
	_init();
    }

    public LJMethod(
	String name,
	int access,
	LJType returnType,
	LJArgument argument
    ) {
	name_ = name;
	access_ = access;
	returnType_ = returnType;
	arguments_ = new LJArgument[] { argument };
	_init();
    }

    public LJMethod(
	String name,
	int access,
	LJType returnType,
	LJArgument argument1,
	LJArgument argument2
    ) {
	name_ = name;
	access_ = access;
	returnType_ = returnType;
	arguments_ = new LJArgument[] { argument1, argument2 };
	_init();
    }

    public LJMethod(
	String name,
	int access,
	LJType returnType,
	LJArgument argument1,
	LJArgument argument2,
	LJArgument argument3
    ) {
	name_ = name;
	access_ = access;
	returnType_ = returnType;
	arguments_ = new LJArgument[] { argument1, argument2, argument3 };
	_init();
    }

    public LJMethod(
	String name,
	int access,
	LJType returnType,
	LJArgument[] arguments
    ) {
	name_ = name;
	access_ = access;
	returnType_ = returnType;
	arguments_ = arguments;
	_init();
    }

    private void _init() {
	StringBuffer buffer = new StringBuffer();
	buffer.append(name_);
	if (arguments_ != null) {
	    for (int i = 0;i < arguments_.length;i++) {
		buffer.append(arguments_[i].getType().getName());
	    }
	}
	id_ = new String(buffer);
	exceptions_ = null;
	final_ = false;
    }

    public final void setException(LJType exception) {
	exceptions_ = new LJType[] { exception };
    }

    public final void setExceptions(LJType[] exceptions) {
	exceptions_ = new LJType[exceptions.length];
	System.arraycopy(exceptions, 0, exceptions_, 0, exceptions.length);
    }

    public final void setFinal(boolean isFinal) {
	final_ = isFinal;
    }

    public final void setStatic(boolean isStatic) {
	static_ = isStatic;
    }

    public final void setImplementation(String implementation) {
	implementation_ = implementation;
    }

    public final void insertImplementation(String fragment) {
	implementation_ = fragment + implementation_;
    }

    public final void appendImplementation(String fragment) {
	implementation_ = implementation_ + fragment;
    }

    public final void setDescription(String desc) {
	desc_ = desc;
    }

    public final String getName() {
	return (name_);
    }

    public final int getAccessMode() {
	return (access_);
    }

    public final String getID() {
	return (id_);
    }

    public final LJArgument[] getArguments() {
	if (arguments_ == null) {
	    return (null);
	}
	LJArgument[] arguments = new LJArgument[arguments_.length];
	System.arraycopy(arguments_, 0, arguments, 0, arguments_.length);
	return (arguments);
    }

    public final LJType getReturnType() {
	return (returnType_);
    }

    public final LJType[] getExceptions() {
	if (exceptions_ == null) {
	    return (null);
	}
	LJType[] exceptions = new LJType[exceptions_.length];
	System.arraycopy(exceptions_, 0, exceptions, 0, exceptions_.length);
	return (exceptions);
    }	

    public final boolean isFinal() {
	return (final_);
    }

    public final boolean isStatic() {
	return (static_);
    }

    public final String getImplementation() {
	return (implementation_);
    }

    public final String getDescription() {
	return (desc_);
    }

    public final Object getProperty(String key) {
	return (properties_.get(key));
    }

    public final Map getProperties() {
	return ((Map)properties_.clone());
    }

    public final void setProperty(String key, Object value) {
	properties_.put(key, value);
    }

    public final void setProperties(Map properties) {
//System.out.println(properties);
	properties_.putAll(properties);
    }
}
